SetBaleAttachEvent = {};
SetBaleAttachEvent_mt = Class(SetBaleAttachEvent, Event);
  
InitEventClass(SetBaleAttachEvent, "SetBaleAttachEvent");
  
function SetBaleAttachEvent:emptyNew()
     local self = Event:new(SetBaleAttachEvent_mt);
      self.className="SetBaleAttachEvent";
      return self;
end;
  
function SetBaleAttachEvent:new(object, baleAttach)
      local self = SetBaleAttachEvent:emptyNew()
      self.object = object;
      self.baleAttach = baleAttach;
      return self;
end;
  
function SetBaleAttachEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.baleAttach = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetBaleAttachEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.baleAttach);
end;
  
function SetBaleAttachEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsBaleAttached(self.baleAttach, true);
end;
  
function SetBaleAttachEvent.sendEvent(vehicle, baleAttach, noEventSend)
      if baleAttach ~= vehicle.isBaleAttach then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetBaleAttachEvent:new(vehicle, baleAttach), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetBaleAttachEvent:new(vehicle, baleAttach));
              end;
          end;
      end;
end;

