---xyzspain
---special thanks to Hummel by scripts in Swadro2000
-- edited to fully MP functionality by modelleicher

TransportRoundBale= {};


function TransportRoundBale.prerequisitesPresent(specializations)
   return true;
end;

function TransportRoundBale:load(xmlFile)
-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	self.setStateEvent= SpecializationUtil.callSpecializationsFunction("setStateEvent");
	
	
	
	--rotaciones y translaciones
	
	---lift 
	    local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
	
	
	
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
      
    end;
		 local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
      
    end;
			 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
      
    end;
		 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
      
    end;
		 local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
      
    end;
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	local translationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation2#index"));
    if translationNode2 ~= nil then
        self.translation2 = {};
        self.translation2.node = translationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#minTrans"));
        self.translation2.minTrans = {};
        self.translation2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation2#maxTrans"));
        self.translation2.maxTrans = {};
        self.translation2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation2.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation2#transTime"), 2)*1000;
      
    end;
	local translationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation3#index"));
    if translationNode3 ~= nil then
        self.translation3 = {};
        self.translation3.node = translationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#minTrans"));
        self.translation3.minTrans = {};
        self.translation3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation3#maxTrans"));
        self.translation3.maxTrans = {};
        self.translation3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation3.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation3#transTime"), 2)*1000;
      
    end;
	local translationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation4#index"));
    if translationNode4 ~= nil then
        self.translation4 = {};
        self.translation4.node = translationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#minTrans"));
        self.translation4.minTrans = {};
        self.translation4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation4#maxTrans"));
        self.translation4.maxTrans = {};
        self.translation4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation4.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation4#transTime"), 2)*1000;
      
    end;
	------------------------------
	
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");


	 self.rotParts =false;

	
	self.rotation1max=false; 
	self.rotation2max=false;
	self.rotation3max=false; 
	self.rotation4max=false;
	self.rotation5max=false; 
	self.rotation6max=false;
	self.unload=false;
	self.translation1max=false;
	self.translation2max= false;
	self.translation3max=false;
	self.translation4max= false;
			---------------------------
		
	
	
end;	
function TransportRoundBale:delete()
  
end;
function TransportRoundBale:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TransportRoundBale:keyEvent(unicode, sym, modifier, isDown)

end;



function TransportRoundBale:update(dt)
	
	
if self.attacherVehicle then

		
	if self:getIsActiveForInput() then
	 

---------------	
	
		
						------------------------- lower raise-------------
			
		if not self.rotation1max and not self.rotation2max	then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
							self:setStateEvent("rotParts", not self.rotParts)
							
			end;
		end;
		if self.rotParts then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
								self:setStateEvent("rotation1max", not self.rotation1max)
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								self:setStateEvent("rotation2max", not self.rotation2max)
			end;
			if InputBinding.hasEvent(InputBinding.UNLOAD) then
								self:setStateEvent("unload", not self.unload)
							
			end;
		end;
	end;		
end;
			if self.rotation1max then
				if not self.unload then
					local x, y, z = getRotation(self.rotation1.node);
					if z <  Utils.degToRad(-18)  then
						self.rotation3max=true; 
						self.translation1max=true;
					elseif z > Utils.degToRad(-14) then
						self.rotation3max=false; 
						self.translation1max=false;
					end;
				end
			else
			self.rotation3max=false;
			self.rotation5max=false;
			self.translation1max=false;
			end;
			
			if self.rotation2max then
				if not self.unload then
					local x, y, z = getRotation(self.rotation2.node);
					if z >  Utils.degToRad(18)  then
						self.rotation4max=true; 
						self.translation2max=true;
					elseif z < Utils.degToRad(14) then
					self.rotation4max=false; 
					self.translation2max=false;
					end;
				end;
			else
			self.rotation4max=false;
			self.rotation6max=false;
			self.translation2max=false;
			end;
			----unload
			if self.unload and self.rotation1max then
				self.rotation5max=true;
				
			end;	
			if self.unload and self.rotation2max then
				self.rotation6max=true;
				
			end;	
			
		if self.rotParts  then
			
					if not self.rotation3max then
						if not self.rotation5max then
							self.translation3max=true;
						else	
							self.translation3max=false;
						end;	
					else
					self.translation3max=false;
					end;
					
					if not self.rotation4max then
						if not self.rotation6max then
							self.translation4max=true;
						else	
							self.translation4max=false;
						end;	
					else
					self.translation4max=false;
					end;
				
		else 
			self.translation3max=false;
			self.translation4max= false;
		end;	
	----rotaciones y translaciones

		if self.rotation1max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	if self.rotation2max ~= nil then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.rotation3max ~= nil  then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;

	if self.rotation4max ~= nil then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	if self.rotation5max ~= nil  then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;

	if self.rotation6max ~= nil  then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;	

	if self.translation1 ~= nil  then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end;
	if self.translation2 ~= nil then 
		local x, y, z = getTranslation(self.translation2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation2.maxTrans, self.translation2.minTrans, 3, self.translation2.transTime, dt, not self.translation2max); 
		setTranslation(self.translation2.node, unpack(newTrans)); 
	end;
	if self.translation3 ~= nil  then 
		local x, y, z = getTranslation(self.translation3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation3.maxTrans, self.translation3.minTrans, 3, self.translation3.transTime, dt, not self.translation3max); 
		setTranslation(self.translation3.node, unpack(newTrans)); 
	end;
	if self.translation4 ~= nil  then 
		local x, y, z = getTranslation(self.translation4.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation4.maxTrans, self.translation4.minTrans, 3, self.translation4.transTime, dt, not self.translation4max); 
		setTranslation(self.translation4.node, unpack(newTrans)); 
	end;
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
		end;
		

	for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
		
		
		
		self:setHydraulicDirection();	

end;



function TransportRoundBale:draw()  
  	
		if not self.rotParts then
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
        elseif self.rotParts then
			if self.unload then
              g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".8"), self.typeDesc), InputBinding.UNLOAD);
			else
			 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".9"), self.typeDesc), InputBinding.UNLOAD);
			 end;
		 if not self.rotation1max then
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".4"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
           else
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".5"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		    end; 
			if not self.rotation2max then
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".6"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
           else
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".7"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
           end; 
		   
		 elseif self.rotParts and not self.rotation1max and not self.rotation2max then
		 g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		 
	 end;   
		   
		   
end;
function TransportRoundBale:onAttach(attacherVehicle)


end;
function TransportRoundBale:onDetach()

	
end;

function TransportRoundBale:onLeave()

 
end;

function TransportRoundBale:onDeactivate()
 
end;
function TransportRoundBale:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end; 







function TransportRoundBale:getSaveAttributesAndNodes(nodeIdent)
-- if self.rotParts== true  then
					
  -- open = "true";	
 -- else		
	-- open = "false";	
-- end;		
		

	--'name="'..tostring(name)..'" name="'..tonumber(name)..'"';
	 -- local attributes = 'open="'..tostring(open)..'"';
	
 -- return attributes, nil;
end;


function TransportRoundBale:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
  -- local open = getXMLString(xmlFile, key.."#open");
	
	-- if open == "true" and not resetVehicles then
	
		 -- self.translation3max  =true ;
		  -- self.translation4max  = true ;
		-- self.rotParts =true;
		
	 -- end; 
	 -- if open == "false" and not resetVehicles then
	
		 -- self.translation3max  =false ;
		  -- self.translation4max  = false ;
		-- self.rotParts =false;
		
	 -- end; 
	
     -- return BaseMission.VEHICLE_LOAD_OK;
end;



function TransportRoundBale:setStateEvent(level1, value, noEventSend)
	
    if value== true then
      value = "true"
    elseif value==false then
      value = "false"
    elseif value ~= "true" and value ~= "false" then
      value = string.format("%f", value)
    end
	
	TransportRoundBaleEvent.sendEvent(self, level1, value, noEventSend);
    	
	if value== "true" then
      value = true
    elseif value=="false" then
      value = false
    elseif value ~= true and value ~= false then
      value = value * 1.0
    end
	
    self[level1]= value;
end;

function TransportRoundBale:readStream(streamId, connection)  
	

	self.rotParts = streamReadBool(streamId)
	self.unload = streamReadBool(streamId)
	self.rotation1max = streamReadBool(streamId)
	self.rotation2max = streamReadBool(streamId)
	
end

function TransportRoundBale:writeStream(streamId, connection)
	
	streamWriteBool(streamId, self.rotParts)
	streamWriteBool(streamId, self.rotation1max)
		streamWriteBool(streamId, self.unload)
	streamWriteBool(streamId, self.rotation2max)
end;


TransportRoundBaleEvent = {};
TransportRoundBaleEvent_mt = Class(TransportRoundBaleEvent, Event);

InitEventClass(TransportRoundBaleEvent, "TransportRoundBaleEvent");

function TransportRoundBaleEvent:emptyNew()  
    local self = Event:new(TransportRoundBaleEvent_mt );
    self.className="TransportRoundBaleEvent";
    return self;
end;

function TransportRoundBaleEvent:new(object, level1, value) 
    self.object = object;
    self.level1 = level1;
    self.value = value;

    return self;
end;

function TransportRoundBaleEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.level1 = streamReadString(streamId);
    self.value = streamReadString(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function TransportRoundBaleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteString(streamId, self.level1 );
    streamWriteString(streamId, self.value );
end;

function TransportRoundBaleEvent:run(connection)
    self.object:setStateEvent(self.level1, self.value, true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(TransportRoundBaleEvent:new(self.object, self.level1, self.value), nil, connection, self.object);
    end;
end;

function TransportRoundBaleEvent.sendEvent(object, level1, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(TransportRoundBaleEvent:new(object, level1, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(TransportRoundBaleEvent:new(object, level1, value));
		end;
	end;
end;

-- MP Fix by modelleicher:
TransportRoundBaleMPFixEvent = {};
TransportRoundBaleMPFixEvent_mt = Class(TransportRoundBaleMPFixEvent, Event);

InitEventClass(TransportRoundBaleMPFixEvent, "TransportRoundBaleMPFixEvent");

function TransportRoundBaleMPFixEvent:emptyNew()  
    local self = Event:new(TransportRoundBaleMPFixEvent_mt );
    self.className="TransportRoundBaleMPFixEvent";
    return self;
end;

function TransportRoundBaleMPFixEvent:new(object, direction) 
    self.object = object;
    self.direction = direction;
    return self;
end;

function TransportRoundBaleMPFixEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.direction = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function TransportRoundBaleMPFixEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, self.direction );
end;

function TransportRoundBaleMPFixEvent:run(connection)
    self.object:setHydraulicUpDown(self.direction, true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(TransportRoundBaleMPFixEvent:new(self.object, self.direction), nil, connection, self.object);
    end;
end;

function TransportRoundBaleMPFixEvent.sendEvent(object, dir, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(TransportRoundBaleMPFixEvent:new(object, dir), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(TransportRoundBaleMPFixEvent:new(object, dir));
		end;
	end;
end;
