WoodWireAttachEvent = {};
WoodWireAttachEvent_mt = Class(WoodWireAttachEvent, Event);

InitEventClass(WoodWireAttachEvent, "WoodWireAttachEvent");

function WoodWireAttachEvent:emptyNew()
    local self = Event:new(WoodWireAttachEvent_mt);
    self.className="WoodWireAttachEvent";
    return self;
end;

function WoodWireAttachEvent:new(object, state)
    local self = WoodWireAttachEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function WoodWireAttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function WoodWireAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function WoodWireAttachEvent:run(connection)
	if self.state then
		self.object:attachTrunksWire(true);
	else
		self.object:detachTrunksWire(true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(WoodWireAttachEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;


function WoodWireAttachEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WoodWireAttachEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(WoodWireAttachEvent:new(vehicle, state));
		end;
	end;
end;
