SetToggleRightFlapEvent = {};
SetToggleRightFlapEvent_mt = Class(SetToggleRightFlapEvent, Event);

InitEventClass(SetToggleRightFlapEvent, "SetToggleRightFlapEvent");

function SetToggleRightFlapEvent:emptyNew()
    local self = Event:new(SetToggleRightFlapEvent_mt);
    self.className="SetToggleRightFlapEvent";
    return self;
end;

function SetToggleRightFlapEvent:new(vehicle, rightFlapState)
    local self = SetToggleRightFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.rightFlapState = rightFlapState;
    return self;
end;

function SetToggleRightFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rightFlapState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetToggleRightFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.rightFlapState);
end;

function SetToggleRightFlapEvent:run(connection)   
	self.vehicle:setToggleRightFlap(self.rightFlapState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetToggleRightFlapEvent:new(self.vehicle, self.rightFlapState), nil, connection, self.vehicle);
    end;
end;

function SetToggleRightFlapEvent.sendEvent(vehicle, rightFlapState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetToggleRightFlapEvent:new(vehicle, rightFlapState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetToggleRightFlapEvent:new(vehicle, rightFlapState));
		end;
	end;
end;