-- Passenger on leave event-class
PassengerLeaveEvent = {};
PassengerLeaveEvent_mt = Class(PassengerLeaveEvent, Event);

InitEventClass(PassengerLeaveEvent, "PassengerLeaveEvent");

function PassengerLeaveEvent:emptyNew()
    local self = Event:new(PassengerLeaveEvent_mt);
    self.className="PassengerLeaveEvent";
    return self;
end;

function PassengerLeaveEvent:new(vehicle)
    local self = PassengerLeaveEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function PassengerLeaveEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

    self:run(connection);
end;

function PassengerLeaveEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
end;

function PassengerLeaveEvent:run(connection)
	self.vehicle:onPassengerLeave(true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(PassengerLeaveEvent:new(self.vehicle), nil, connection, self.vehicle);
    end;
end;

function PassengerLeaveEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PassengerLeaveEvent:new(vehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PassengerLeaveEvent:new(vehicle));
		end;
	end;
end;

