--
-- Specialisation for Claas Carat 180TD
--
-- Author: Mofi (BM-Modding)


claasCarat180TD = {};

function claasCarat180TD.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function claasCarat180TD:load(xmlFile)
    self.setVehicleIncreaseRpm = SpecializationUtil.callSpecializationsFunction("setVehicleIncreaseRpm");
    self.saveMinimumRpm = 0;
end;

function claasCarat180TD:delete()
end;

function claasCarat180TD:readStream(streamId, connection)
end;

function claasCarat180TD:writeStream(streamId, connection)
end;

function claasCarat180TD:mouseEvent(posX, posY, isDown, isUp, button)
end;

function claasCarat180TD:keyEvent(unicode, sym, modifier, isDown)
end;

function claasCarat180TD:update(dt)
    if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_CLOSING) then
        Cylindered.updateMovingPart(self, self.movingParts[1]);
    end;

    for _, part in pairs(self.movingParts) do
		part.isDirty = true;
	end;
	
	if self.tipState == Trailer.TIPSTATE_OPENING then
	    if self.attacherVehicle  ~= nil then
            if self.attacherVehicle.motor ~= nil then
                self:setVehicleIncreaseRpm(dt, true);
            end;
        end;
        elseif (self.tipState == Trailer.TIPSTATE_OPEN or self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_CLOSED) then
            self:setVehicleIncreaseRpm(nil, false);
    end;
end;

function claasCarat180TD:updateTick(dt)
end;

function claasCarat180TD:draw()
end;

function claasCarat180TD:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy1 == nil then
		self.attacherVehicleCopy1 = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.saveMinimumRpm = self.attacherVehicle.motor.minRpm;
	else
		if self.attacherVehicle.saveMinRpm ~= nil then
			self.saveMinimumRpm = self.attacherVehicle.saveMinimumRpm;
		else
			self.attacherVehicle.saveMinimumRpm  = 100;
		end;
	end;
end;

function claasCarat180TD:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy1 == steerable then
			steerable.motor.minRpm = self.saveMinimumRpm;
			self.attacherVehicleCopy1 = nil;
		end;
	end;
end;

function claasCarat180TD:setVehicleIncreaseRpm(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinimumRpm ~= 0 and
		self.attacherVehicle.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinimumRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinimumRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000012*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;


