--
-- AttacherImplements
-- This is the specialization for AttacherImplements
--
-- M@D Author  Headshot XXL
-- M@D date 27.02.2010
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

AttacherImplements = {};

function AttacherImplements.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AttacherImplements:load(xmlFile)

	self.verteiler = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verteiler#index"));
	self.backupCuttingAreas = self.cuttingAreas;
	
end;

function AttacherImplements:delete()
end;

function AttacherImplements:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttacherImplements:keyEvent(unicode, sym, modifier, isDown)
end;

function AttacherImplements:update(dt)

	if self:getIsActive() then

		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            self:handleLowerImplementEvent();
        end;
		
		if self.attachedImplements ~= nil then
			if table.getn(self.attachedImplements) == 1 then
				setVisibility(self.verteiler, false);
				if self.attachedImplements[1].object.sprayCuttingAreas ~= nil then
					self.cuttingAreas = self.attachedImplements[1].object.sprayCuttingAreas;
				elseif self.attachedImplements[1].object.cuttingAreas ~= nil and self.attachedImplements[1].object.sprayCuttingAreas == nil then
					self.cuttingAreas = self.attachedImplements[1].object.cuttingAreas;
				end;
			else
				self.cuttingAreas = self.backupCuttingAreas;
				setVisibility(self.verteiler, true);
			end;
		end;
		
	end;

end;

function AttacherImplements:draw()

	if self.attachedImplements ~= nil then
		if table.getn(self.attachedImplements) == 1 then		
			if self.attacherJoints[self.attachedImplements[1].jointDescIndex].moveDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_OBJECT"), self.attachedImplements[1].object.typeDesc), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower_OBJECT"), self.attachedImplements[1].object.typeDesc), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;

end;
