Z173 = {};

function Z173.prerequisitesPresent(specializations)
	return true;
end;

function Z173:load(xmlFile)
	local Rozlozenie = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rozlozenie#index"));
	if Rozlozenie ~= nil then
		self.Rozlozenie = Rozlozenie;
	end;
	
	self.mowerParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.mowerParticleSystems.mowerParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.mowerParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
end;
	
function Z173:delete()
	Utils.deleteParticleSystem(self.mowerParticleSystems);
end;

function Z173:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z173:keyEvent(unicode, sym, modifier, isDown)
end;

function Z173:update(dt)
	local nearestDistance = 2.1;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);

	local px, py, pz = getWorldTranslation(self.Rozlozenie); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz); 
	if distance < nearestDistance then
		self.przyKosiarce = true; 
	else
		self.przyKosiarce = false; 
	end;

	if self.przyKosiarce or self.isEntered then
		if InputBinding.hasEvent(InputBinding.Rozlozenie) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
	end;

	if self.setAnimationTime ~= nil then
		if self.isTurnedOn then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
	end;
		
	if self.przyKosiarce then
		if self.animationParts[1].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Rozloz kosiarke", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Rozlozenie)));
 		else
			g_currentMission:addExtraPrintText(string.format("%s: Zloz kosiarke", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Rozlozenie)));
		end;
 	end;
	
	if self:getIsActive() then
		if self.isTurnedOn and self.movingDirection ~= 0 and self:isLowered(false) then
			Utils.setEmittingState(self.mowerParticleSystems, true);
		else
			Utils.setEmittingState(self.mowerParticleSystems, false);
		end;
	end;
end;

function Z173:draw()
end;

function Z173:onDetach()
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end;
end;

function Z173:onLeave()
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end; 
end;

function Z173:onDeactivate()
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end; 
end;