-- Manure Mod
-- V1.2.0
-- 21.06.13

local orgi_sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	orgi_sprayerUpdateTick(self, dt)
	if self.isTurnedOn and self.fillLevel > 0 then
		local windrowId = nil;
		if self.currentFillType == Fillable.FILLTYPE_MANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId;
			end;
		elseif self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
			if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] then
				windrowId = g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId;
			end;
		end;
		if windrowId ~= nil then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2)
			end;
		end;
	end;
end;

Utils.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2)
	local IDs,detailId = {},g_currentMission.terrainDetailId;
	table.insert(IDs,g_currentMission.cultivatorChannel);
	table.insert(IDs,g_currentMission.sowingChannel);
	table.insert(IDs,g_currentMission.ploughChannel);
	local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
	for i = 1, table.getn(IDs) do
		setDensityMaskedParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, IDs[i], 1, 1)
	end
end;

local orgi_UpdateDestroyCommonArea = Utils.updateDestroyCommonArea;
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	orgi_UpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;

local orgi_cutFruitArea = Utils.cutFruitArea;
Utils.cutFruitArea =  function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	local pixelsSum, numPixels, spraySum = orgi_cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	if destroySpray then
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
			Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
	end;
	return pixelsSum, numPixels, spraySum;
end;

local orgi_updateSowingArea = Utils.updateSowingArea;
Utils.updateSowingArea = function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	local numPixels, numDetailPixels = orgi_updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	return numPixels, numDetailPixels;
end;