WarfamaN227 = {};

function WarfamaN227.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;
function WarfamaN227:load(xmlFile)
	self.toggleAdapter = SpecializationUtil.callSpecializationsFunction("toggleAdapter");
	self.toggleGrid = SpecializationUtil.callSpecializationsFunction("toggleGrid");
	self.toggleAdditionalBoards = SpecializationUtil.callSpecializationsFunction("toggleAdditionalBoards");
	self.toggleLeftDoor = SpecializationUtil.callSpecializationsFunction("toggleLeftDoor");
	self.toggleRightDoor = SpecializationUtil.callSpecializationsFunction("toggleRightDoor");
	self.toggleBackDoor = SpecializationUtil.callSpecializationsFunction("toggleBackDoor");
	
	self.leftDoorAnimation = getXMLString(xmlFile, "vehicle.leftDoorAnimation#animationName");
	self.leftDoorActive = true;
	
	self.rightDoorAnimation = getXMLString(xmlFile, "vehicle.rightDoorAnimation#animationName");
	self.rightDoorActive = true;
	
	self.backDoorAnimation = getXMLString(xmlFile, "vehicle.backDoorAnimation#animationName");
	self.backDoorActive = true;
	self.backDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backDoor#index"));
	
	self.grid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grid#index"));
    self.gridActive = true;
	
	self.additionalBoards = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.additionalBoards#index"));
    self.additionalBoardsActive = false;
	
	self.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.adapter#index"));
    self.adapterActive = true;
end;

function WarfamaN227:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'grid="'.. tostring(self.gridActive) ..'" adapter="'.. tostring(self.adapterActive) ..'" additionalBoards="'.. tostring(self.additionalBoardsActive) ..'"';
	return attributes, nil;
end;

function WarfamaN227:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local gridActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#grid"), true);
		local adapterActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#adapter"), true);
		local additionalBoards = Utils.getNoNil(getXMLBool(xmlFile, key.."#additionalBoards"), false);
		self:toggleGrid(gridActive);
		self:toggleAdapter(adapterActive);
		self:toggleAdditionalBoards(additionalBoards);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function WarfamaN227:delete()
end;

function WarfamaN227:readStream(streamId, connection)
	self:toggleGrid(streamReadBool(streamId), true);
	self:toggleAdditionalBoards(streamReadBool(streamId), true);
	self:toggleAdapter(streamReadBool(streamId), true);
	self:toggleLeftDoor(streamReadBool(streamId), true);
	self:toggleRightDoor(streamReadBool(streamId), true);
	self:toggleBackDoor(streamReadBool(streamId), true);
end;

function WarfamaN227:writeStream(streamId, connection)
	streamWriteBool(streamId, self.gridActive);
	streamWriteBool(streamId, self.additionalBoardsActive);
	streamWriteBool(streamId, self.adapterActive);
	streamWriteBool(streamId, self.leftDoorActive);
	streamWriteBool(streamId, self.rightDoorActive);
	streamWriteBool(streamId, self.backDoorActive);
end;

function WarfamaN227:readUpdateStream(streamId, timestamp, connection)
end;

function WarfamaN227:writeUpdateStream(streamId, connection, dirtyMask)
end;

function WarfamaN227:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WarfamaN227:keyEvent(unicode, sym, modifier, isDown)
end;

function WarfamaN227:update(dt)
	setVisibility(self.additionalBoards, self.additionalBoardsActive);
	setVisibility(self.grid, self.gridActive);
    setVisibility(self.adapter, self.adapterActive);
	setVisibility(self.backDoor, not self.adapterActive);	
	
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEGRID) then
            self:toggleGrid(not self.gridActive);
        end;
		if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLELEFTDOOR) then
            self:toggleLeftDoor(not self.leftDoorActive);
        end;
		if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLERIGHTDOOR) then
            self:toggleRightDoor(not self.rightDoorActive);
        end;
		if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEBACKDOOR) then
            self:toggleBackDoor(not self.backDoorActive);
        end;
		if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
			if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS) then
				self:toggleAdditionalBoards(not self.additionalBoardsActive);
			end;
			if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEADAPTER) then
				self:toggleAdapter(not self.adapterActive);
			end;
		end;
    end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;
	elseif self.currentFillType == Fillable.FILLTYPE_MANURE then
		if self.adapterActive == false then
			self:toggleAdapter(true);
		end;
		if self.additionalBoardsActive == true then
			self:toggleAdditionalBoards(false);
		end;
	end
end;
function WarfamaN227:onLeave()
end;
function WarfamaN227:draw()
	if self.gridActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_hideGrid"),  InputBinding.WARFAMA_TOGGLEGRID);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_showGrid"),  InputBinding.WARFAMA_TOGGLEGRID);
	end;
	if self.leftDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_openLeftDoor"),  InputBinding.WARFAMA_TOGGLELEFTDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_closeLeftDoor"),  InputBinding.WARFAMA_TOGGLELEFTDOOR);
	end;
	if self.rightDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_openRightDoor"),  InputBinding.WARFAMA_TOGGLERIGHTDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_closeRightDoor"),  InputBinding.WARFAMA_TOGGLERIGHTDOOR);
	end;
	if self.backDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_openBackDoor"),  InputBinding.WARFAMA_TOGGLEBACKDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_closeRightDoor"),  InputBinding.WARFAMA_TOGGLEBACKDOOR);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.additionalBoardsActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_hideAdditionalBoards"),  InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_showAdditionalBoards"),  InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS);
		end;
		if self.adapterActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_hideAdapter"),  InputBinding.WARFAMA_TOGGLEADAPTER);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_showAdapter"),  InputBinding.WARFAMA_TOGGLEADAPTER);
		end;
	end;
end;

function WarfamaN227:toggleGrid(gridState, noEventSend)
	SetGridEvent.sendEvent(self, gridState, noEventSend);
    self.gridActive = gridState;
end;

function WarfamaN227:toggleAdditionalBoards(additionalBoardsState, noEventSend)
	SetAdditionalBoardsEvent.sendEvent(self, additionalBoardsState, noEventSend);
    self.additionalBoardsActive = additionalBoardsState;
end;


function WarfamaN227:toggleAdapter(adapterState, noEventSend)
	SetAdapterEvent.sendEvent(self, adapterState, noEventSend);
    self.adapterActive = adapterState;
end;

function WarfamaN227:toggleLeftDoor(leftDoorState,noEventSend)
	SetLeftDoorEvent.sendEvent(self, leftDoorState, noEventSend);
	if leftDoorState then
		if self.leftDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftDoorAnimation, -1, nil, true);
			self.leftDoorActive = true;
		end;
	else
		if self.leftDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftDoorAnimation, 1, nil, true);
			self.leftDoorActive = false;
		end;
	end;
end;

function WarfamaN227:toggleRightDoor(rightDoorState,noEventSend)
	SetRightDoorEvent.sendEvent(self, rightDoorState, noEventSend);
	if rightDoorState then
		if self.rightDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightDoorAnimation, -1, nil, true);
			self.rightDoorActive = true;
		end;
	else
		if self.rightDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightDoorAnimation, 1, nil, true);
			self.rightDoorActive = false;
		end;
	end;
end;

function WarfamaN227:toggleBackDoor(backDoorState,noEventSend)
	SetBackDoorEvent.sendEvent(self, backDoorState, noEventSend);
	if backDoorState then
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, -1, nil, true);
			self.backDoorActive = true;
		end;
	else
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, 1, nil, true);
			self.backDoorActive = false;
		end;
	end;
end;