SetToggleNadstawyEvent = {};
SetToggleNadstawyEvent_mt = Class(SetToggleNadstawyEvent, Event);
InitEventClass(SetToggleNadstawyEvent, "SetToggleNadstawyEvent");
function SetToggleNadstawyEvent:emptyNew()
      local self = Event:new(SetToggleNadstawyEvent_mt);
      self.className="SetToggleNadstawyEvent";
      return self;
end;
function SetToggleNadstawyEvent:new(object, nadstawyActive)
      local self = SetToggleNadstawyEvent:emptyNew()
      self.nadstawyActive = nadstawyActive;
      self.object = object;
      return self;
end;
function SetToggleNadstawyEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.nadstawyActive = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function SetToggleNadstawyEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.nadstawyActive);
end;
function SetToggleNadstawyEvent:run(connection)
      self.object:setToggleNadstawy(self.nadstawyActive, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetToggleNadstawyEvent:new(self.object, self.nadstawyActive), nil, connection, self.object);
      end;
end;