SetLeftDoorEvent = {};
SetLeftDoorEvent_mt = Class(SetLeftDoorEvent, Event);

InitEventClass(SetLeftDoorEvent, "SetLeftDoorEvent");

function SetLeftDoorEvent:emptyNew()
    local self = Event:new(SetLeftDoorEvent_mt);
    self.className="SetLeftDoorEvent";
    return self;
end;

function SetLeftDoorEvent:new(vehicle, leftDoorState)
    local self = SetLeftDoorEvent:emptyNew()
    self.vehicle = vehicle;
	self.leftDoorState = leftDoorState;
    return self;
end;

function SetLeftDoorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.leftDoorState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLeftDoorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.leftDoorState);
end;

function SetLeftDoorEvent:run(connection)   
	self.vehicle:toggleLeftDoor(self.leftDoorState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLeftDoorEvent:new(self.vehicle, self.leftDoorState), nil, connection, self.vehicle);
    end;
end;

function SetLeftDoorEvent.sendEvent(vehicle, leftDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLeftDoorEvent:new(vehicle, leftDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLeftDoorEvent:new(vehicle, leftDoorState));
		end;
	end;
end;