MB1518 = {};

function MB1518.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function MB1518:load(xmlFile)

	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {};
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {};
    self.animParts = {}
	self.collisionArm = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
	end;
end;

function MB1518:delete()
end;

function MB1518:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MB1518:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym==Input.KEY_l then
		self.Go.pillar = not self.Go.pillar;
		self.Done.pillar = true;
	end;

end;

function MB1518:update(dt)

	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false);
	end;
end;

function MB1518:draw()

end;

function MB1518:onEnter()

end;

function MB1518:onLeave()

end;

function MB1518:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;
			self.CheckDone[varName] = true;
		end;
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;
		end;
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;
			self.CheckDone[varName] = false;
		end;
	end;
end;
