﻿--
--
--		MapBuayableObjetcs_drawPart
--@date: 02/10/2012
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0
--
--darf in jede Map eingebaut werden, MapBuayableObjetcs.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission
--
 
masterTriggerAllowed = 0;


ObjectBuy = {};
ObjectBuy.drawParts = {};
ObjectBuy.drawPartsIcon = {};
ObjectBuy.drawPartsMaster = {};

function ObjectBuy:loadMap(name)

	self.mapName = g_currentMission.missionInfo.mapId
	
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/MapBuyableObjects.xml";
	if g_currentMission.missionStats.playTime == 0 then
		self.firstRun = false;
	else
		self.firstRun = true;
	end;
	
	self.triggerUpdate = true;
end;
function ObjectBuy:deleteMap()

	if table.getn(ObjectBuy.drawParts) ~= 0 then
		for k=1,table.getn(ObjectBuy.drawParts) do 
			ObjectBuy.drawParts[k] = nil;
		end;
	end;
	if table.getn(ObjectBuy.drawPartsIcon) ~= 0 then
		for k=1,table.getn(ObjectBuy.drawPartsIcon) do 
			ObjectBuy.drawPartsIcon[k] = nil;
		end;
	end;
	if table.getn(ObjectBuy.drawPartsMaster) ~= 0 then
		for k=1,table.getn(ObjectBuy.drawPartsMaster) do 
			ObjectBuy.drawPartsMaster[k] = nil;
		end;
	end;

end;

function ObjectBuy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ObjectBuy:keyEvent(unicode, sym, modifier, isDown)
end;

function ObjectBuy:readStream(streamId, connection)
	self.triggerUpdate = streamReadBool(streamId);
	self.firstRun = streamReadBool(streamId);
end;

function ObjectBuy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.triggerUpdate);
	streamWriteBool(streamId, self.firstRun);
end;

function ObjectBuy:update(dt)

	if g_server ~= nil then
		if self.triggerUpdate then
			for i=1, table.getn(ObjectBuy.drawParts) do
				ObjectBuy.drawParts[i]:visibility(false, false, 3);
			end;
			self.triggerUpdate = false;
		end;
		if self.firstRun then
			ObjectBuy:loadBuyableObjectFromXML();
			self.firstRun = false;			
		end;
	end;

end;

function ObjectBuy:draw()
	
	if table.getn(ObjectBuy.drawParts) ~= 0 then
		for i=1, table.getn(ObjectBuy.drawParts) do
			ObjectBuy.drawParts[i]:draw();
		end;
	end;
	if table.getn(ObjectBuy.drawPartsIcon) ~= 0 then
		for i=1, table.getn(ObjectBuy.drawPartsIcon) do
			ObjectBuy.drawPartsIcon[i]:draw();
		end;
	end;
	if table.getn(ObjectBuy.drawPartsMaster) ~= 0 then
		for i=1, table.getn(ObjectBuy.drawPartsMaster) do
			ObjectBuy.drawPartsMaster[i]:draw();
		end;
	end;

end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	ObjectBuy:saveBuyableObjectToXML();
end;

function ObjectBuy:loadBuyableObjectFromXML()


	if fileExists(self.saveXMLFile) then
		local xmlFile = loadXMLFile("MapBuyableObjects", self.saveXMLFile);
		local a = Utils.getNoNil(getXMLString(xmlFile, "BuyableObjects#mapIdentifier"), nil);
			if (a == self.mapName) then	
				local c = Utils.getNoNil(getXMLInt(xmlFile, "BuyableObjects#withMapBuyableObjects"), 1);
				masterTriggerAllowed = c;
				if c == 1 then
					for i=1, table.getn(self.drawParts) do
							local key = ("BuyableObjects."..ObjectBuy.drawParts[i].buyableText.."");
							ObjectBuy.drawParts[i].newNumber = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Buy"),0);
							ObjectBuy.drawParts[i].newNum = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Delete"),1);
							ObjectBuy.drawParts[i].newTri = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Buy"),0);
							ObjectBuy.drawParts[i].newDelTri = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Delete"),1);
							ObjectBuy.drawParts[i].newTransObj = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trans_Objects"),0);
							--savegame laden, wenn savegame nummer ist wie gekauft/nicht da, dann einmal visibilitiy aufrufen um Event zu senden.					
							if (ObjectBuy.drawParts[i].newNumber == 1 or ObjectBuy.drawParts[i].newNumber == 3) and (ObjectBuy.drawParts[i].newNum == 0 or ObjectBuy.drawParts[i].newNum == 3) and (ObjectBuy.drawParts[i].newTri == 1 or ObjectBuy.drawParts[i].newTri == 3) and (ObjectBuy.drawParts[i].newDelTri == 0 or ObjectBuy.drawParts[i].newDelTri == 3) and (ObjectBuy.drawParts[i].newTransObj == 1 or ObjectBuy.drawParts[i].newTransObj == 3) then
								ObjectBuy.drawParts[i].hasPressedBuy = 1;
								ObjectBuy.drawParts[i].saveGameLoad = true;
								ObjectBuy.drawParts[i].payedPrice = true;
								ObjectBuy.drawParts[i]:visibility(true, false, 1);
								ObjectBuy.drawParts[i].infoToOthers = false;
							end;
					end;

					for i=1, table.getn(self.drawPartsIcon) do
							local key = ("BuyableObjects."..ObjectBuy.drawPartsIcon[i].iconText.."");
							ObjectBuy.drawPartsIcon[i].newNumberIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Buy"),0);
							ObjectBuy.drawPartsIcon[i].newNumIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Delete"),1);
							ObjectBuy.drawPartsIcon[i].newTriIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Buy"),0);
							ObjectBuy.drawPartsIcon[i].newDelTriIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Delete"),1);
							ObjectBuy.drawPartsIcon[i].newTransIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trans_Objects"),0);

							--savegame laden, wenn savegame nummer ist wie gekauft/nicht da, dann einmal visibilitiy aufrufen um Event zu senden.					
							if (ObjectBuy.drawPartsIcon[i].newNumberIcon == 1 or ObjectBuy.drawPartsIcon[i].newNumberIcon == 3) and (ObjectBuy.drawPartsIcon[i].newNumIcon == 0 or ObjectBuy.drawPartsIcon[i].newNumIcon == 3) and (ObjectBuy.drawPartsIcon[i].newTriIcon == 1 or ObjectBuy.drawPartsIcon[i].newTriIcon == 3) and (ObjectBuy.drawPartsIcon[i].newDelTriIcon == 0 or ObjectBuy.drawPartsIcon[i].newDelTriIcon == 3) and (ObjectBuy.drawPartsIcon[i].newTransIcon == 1 or ObjectBuy.drawPartsIcon[i].newTransIcon == 3) then
								ObjectBuy.drawPartsIcon[i]:visibilityIcon(true);
							end;
					end;
					print("Map Buyable Objects, Savegame states was loaded.");
					
					if table.getn(ObjectBuy.drawPartsMaster) ~= 0 then
							ObjectBuy.drawPartsMaster[1]:withoutMBO(false)
					end;

				elseif c == 2 then
					for i=1, table.getn(self.drawParts) do
						ObjectBuy.drawParts[i].hasPressedBuy = 1;
						ObjectBuy.drawParts[i].saveGameLoad = true;
						ObjectBuy.drawParts[i].payedPrice = true;
						ObjectBuy.drawParts[i]:visibility(true, false, 1);
						ObjectBuy.drawParts[i].infoToOthers = false;
					end;
					for i=1, table.getn(self.drawPartsIcon) do
						ObjectBuy.drawPartsIcon[i]:visibilityIcon(true);
					end;
					print("Play without Map Buyable Objects, all objects are there.");
				end;
				
				local b = Utils.getNoNil(getXMLInt(xmlFile, "BuyableObjects#numberOfObjects"), 0);
					if b > table.getn(self.drawParts) then
						ObjectBuy:saveBuyableObjectToXML()
						print("MapBuyableObject: Object deleted from map, Old saves loaded and saved new.");
					elseif b < table.getn(self.drawParts) then 
						ObjectBuy:saveBuyableObjectToXML()
						print("MapBuyableObject: New Object added to map, saves loaded. New Object saved in Savegame XML.");
					end;
			else
				ObjectBuy:saveBuyableObjectToXML()
				print("Warning: MapBuyableObjects can't load ", self.saveXMLFile, ": Name of the current map does not match the match in the savegame.");
			end;
			delete(xmlFile);
	else
		ObjectBuy:saveBuyableObjectToXML()
		print("Warning: MapBuyableObjects can't load ", self.saveXMLFile, ": Playing time is not 0, but Savegame XML does not exist.");
	end;

end;

function ObjectBuy:saveBuyableObjectToXML()

	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("MapBuyableObjects", self.saveXMLFile, "saveObject");
	end;
	
    local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
		xmlFile:write('\n');
        xmlFile:write('<BuyableObjects  mapIdentifier="'..self.mapName..'"  numberOfObjects="'..table.getn(ObjectBuy.drawParts)..'"  withMapBuyableObjects="'..masterTriggerAllowed..'">\n');
		for i=1, table.getn(ObjectBuy.drawParts) do
			xmlFile:write('    <'..ObjectBuy.drawParts[i].buyableText..'  BuyObject_Buy="'..ObjectBuy.drawParts[i].toBuy..'"  BuyObject_Delete="'..ObjectBuy.drawParts[i].toDelete..'"  Trigger_Buy="'..ObjectBuy.drawParts[i].toTrigger..'"  Trigger_Delete="'..ObjectBuy.drawParts[i].toDeleteTrigger..'"  Trans_Objects="'..ObjectBuy.drawParts[i].toTrans..'"/> \n');
		end;		
        xmlFile:write('		<!--BuyObject_buy:0=Objekt noch unsichtbar,nicht gekauft. 1=Objekt wurde gekauft,Sichtbar. 3=Kein Objekt angegeben./--> \n');
        xmlFile:write('		<!--BuyObject_Delete: 0=Objekt wurde durch kauf unsichtbar gestellt. 1=Objekt noch sichtbar. 3=Kein Objekt angegeben./--> \n');
        xmlFile:write('		<!--Trigger_Buy: 0=Trigger wurde noch nicht gekauft. 1=Trigger gekauft. 3=Kein Trigger angegeben./--> \n');
        xmlFile:write('		<!--Trigger_Delete: 0=Trigger wurde durch kauf ohne Funktion. 1=Trigger noch da. 3=Kein Trigger angegeben./--> \n');
        xmlFile:write('		<!--Trans_Objects: 0=Object noch orginal. 1=Object in neuer Position. 3=Kein Object angegeben./--> \n');
        xmlFile:write("</BuyableObjects>");

        xmlFile:close();
    end;	

end;

addModEventListener(ObjectBuy);
