﻿--
--
--
--     <Attribute name="onCreate" type="scriptCallback" value="MapBuyableObject.onCreateMaster"/>
--
--
--		MasterTrigger for MapBuyableObjects
--
--@date: 30/08/2013
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	release 
--
--darf in jede Map eingebaut werden, MapBuyableObject.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission


	print("   Map: Buyable Objects (Master) v1.0  by Bluebaby210 loaded!");


---------------------------------------
function onCreateMaster(self, id)
	--print("						created Master Trigger, id: ", id);
	local masterTrigger = MasterTriggerBuyableAll:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(masterTrigger);
    masterTrigger:load(id);
    masterTrigger:register(true);
	table.insert(ObjectBuy.drawPartsMaster, masterTrigger);
end;

MasterTriggerBuyableAll = {}
MasterTriggerBuyableAll_directory = g_currentModDirectory;
local MasterTriggerBuyableAll_mt = Class(MasterTriggerBuyableAll, Object);

function MasterTriggerBuyableAll:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MasterTriggerBuyableAll_mt);
    self.className = "MasterTriggerBuyableAll";
    return self;
end;

function MasterTriggerBuyableAll:load(id)
	self.triggerId = id
	addTrigger(self.triggerId, "TriggerCallback", self);
	self.playerInTrigger = false;
	self.helpHudState = 0;
	self.firstTriggerRun = true;
	
		self.backgroundHudMaster = createImageOverlay(MasterTriggerBuyableAll_directory.."buyable/New1.png");
		self.modNameHudMaster = createImageOverlay(MasterTriggerBuyableAll_directory.."buyable/modName.png");
		self.bankNoteHudMaster = createImageOverlay(MasterTriggerBuyableAll_directory.."buyable/icon.png");
		self.headHudNewMaster = createImageOverlay(MasterTriggerBuyableAll_directory.."buyable/HeadHud.dds");
		self.leng = getSystemLanguage();

		if self.leng == 1 then
			self.masterFileName = MasterTriggerBuyableAll_directory.."buyable/masterText.xml";
			local xml = loadXMLFile("masterTriggerText", self.masterFileName);
				self.masterText = {};
				self.textLinesPosHeightMaster = {};
				self.textFontSizeMaster = 0.026;
				self.textPosHeightMaster = 0.715;
				self.headlineTextMaster = getXMLString(xml, "masterText.de#Headline");

				local k = 0;
				while true do
					local linesname = string.format("masterText.de.line(%d)", k);
						if not hasXMLProperty(xml, linesname) then
							break;
						end;
					k = k + 1;
					self.masterText[k] = getXMLString(xml, linesname .. "#description");
					self.textLinesPosHeightMaster[k] = self.textPosHeightMaster - (self.textFontSizeMaster * k);
				end; 
				
		elseif self.leng == 5 then
			self.masterFileName = MasterTriggerBuyableAll_directory.."buyable/masterText.xml";
			local xml = loadXMLFile("masterTriggerText", self.masterFileName);
				self.masterText = {};
				self.textLinesPosHeightMaster = {};
				self.textFontSizeMaster = 0.026;
				self.textPosHeightMaster = 0.715;
				self.headlineTextMaster = getXMLString(xml, "masterText.fr#Headline");

				local k = 0;
				while true do
					local linesname = string.format("masterText.fr.line(%d)", k);
						if not hasXMLProperty(xml, linesname) then
							break;
						end;
					k = k + 1;
					self.masterText[k] = getXMLString(xml, linesname .. "#description");
					self.textLinesPosHeightMaster[k] = self.textPosHeightMaster - (self.textFontSizeMaster * k);
				end; 				
		else
			self.masterFileName = MasterTriggerBuyableAll_directory.."buyable/masterText.xml";
			local xml = loadXMLFile("masterTriggerText", self.masterFileName);
				self.masterText = {};
				self.textLinesPosHeightMaster = {};
				self.textFontSizeMaster = 0.026;
				self.textPosHeightMaster = 0.715;
				self.headlineTextMaster = getXMLString(xml, "masterText.en#Headline");

				local k = 0;
				while true do
					local linesname = string.format("masterText.en.line(%d)", k);
						if not hasXMLProperty(xml, linesname) then
							break;
						end;
					k = k + 1;
					self.masterText[k] = getXMLString(xml, linesname .. "#description");
					self.textLinesPosHeightMaster[k] = self.textPosHeightMaster - (self.textFontSizeMaster * k);
				end; 
		
		end;
		
		self.mapTitle = g_currentMission.missionInfo.map.title;
		self.nontabableVehicles = {};
end;

function MasterTriggerBuyableAll:delete()
	removeTrigger(self.triggerId);
end;

function MasterTriggerBuyableAll:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MasterTriggerBuyableAll:keyEvent(unicode, sym, modifier, isDown)
end;

function MasterTriggerBuyableAll:readStream(streamId, connection)
	masterTriggerAllowed = streamReadInt8(streamId);
	if masterTriggerAllowed == 1 or masterTriggerAllowed == 2 then
		setRigidBodyType(self.triggerId, "NoRigidBody")
		local x,y,z = getTranslation(self.triggerId)
		setTranslation(self.triggerId, x, -1000, z)
	end;
end;

function MasterTriggerBuyableAll:writeStream(streamId, connection)
	streamWriteInt8(streamId, masterTriggerAllowed);
end;

function MasterTriggerBuyableAll:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = true;
		end;
	elseif onLeave then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = false;
		end;
		if self.helpHudState == 1 then
			g_currentMission.showHelpText = true;
			self.helpHudState = 0;
		end;
	end;

end;

function MasterTriggerBuyableAll:update(dt)

	if masterTriggerAllowed == 0 then
		if self.playerInTrigger then
			if self.firstTriggerRun then
				local x, y, z = getTranslation(g_currentMission.player.rootNode);
				self.firstTransX = x;
				self.firstTransY = y;
				self.firstTransZ = z;
				self.firstTriggerRun = false;
				for k,v in pairs(g_currentMission.vehicles) do
					if v.onLeave ~= nil and not v.nonTabbable then
						table.insert(self.nontabableVehicles, k);
						v.nonTabbable = true;
					end;
				end;
			end;

			if g_currentMission.player ~= nil then
				setTranslation(g_currentMission.player.rootNode, self.firstTransX, self.firstTransY, self.firstTransZ);
			end;
			if g_currentMission.showHelpText then
				self.helpHudState = 1;
				g_currentMission.showHelpText = false;
			end;
			if InputBinding.hasEvent(InputBinding.MBO_Buy) then
				self:withoutMBO(true);
			end;
			
			if InputBinding.hasEvent(InputBinding.MBO_Preview) then
				self:withoutMBO(false);
			end;
			
		end;
	end;

end;

function MasterTriggerBuyableAll:withoutMBO(without, noEventSend)

	if not noEventSend then
		MasterTriggerBuyableAllEvent.sendEvent(self, without, noEventSend)
	end;
		
		if without then
			masterTriggerAllowed = 2;
			local x,y,z = getTranslation(self.triggerId)
			setRigidBodyType(self.triggerId, "NoRigidBody")
			setTranslation(self.triggerId, x, -1000, z)
			if table.getn(ObjectBuy.drawParts) ~= 0 then
				for i=1, table.getn(ObjectBuy.drawParts) do
					ObjectBuy.drawParts[i].hasPressedBuy = 1
					ObjectBuy.drawParts[i].infoToOthers = false;
					ObjectBuy.drawParts[i].payedPrice = true;
					ObjectBuy.drawParts[i]:visibility(true, false, 1, true);
				end;
			end;
			if table.getn(ObjectBuy.drawPartsIcon) ~= 0 then
				for i=1, table.getn(ObjectBuy.drawPartsIcon) do
					ObjectBuy.drawPartsIcon[i]:visibilityIcon(true, true);
				end;
			end;
		end;
		
		if not without then
			masterTriggerAllowed = 1;
			local x,y,z = getTranslation(self.triggerId)
			setRigidBodyType(self.triggerId, "NoRigidBody")
			setTranslation(self.triggerId, x, -1000, z)
		end;
		
		if table.getn(self.nontabableVehicles) ~= 0 then
			for k,v in pairs(self.nontabableVehicles) do
				g_currentMission.vehicles[v].nonTabbable = false;
			end;
		end;

end;

function MasterTriggerBuyableAll:draw()
	if self.playerInTrigger and masterTriggerAllowed == 0 then
			renderOverlay(self.backgroundHudMaster, 0.25, 0.01, 0.45, 1);
			renderOverlay(self.headHudNewMaster, 0.287, 0.855, 0.308, 0.125);
			renderOverlay(self.modNameHudMaster, 0.36, 0.83, 0.18, 0.035);
			renderOverlay(self.bankNoteHudMaster, 0.627, 0.88, 0.07, 0.11);
			setTextBold(true);
			setTextColor(0,0,0,1);
			renderText(0.33, 0.76, 0.05, self.headlineTextMaster);
			renderText(0.26, 0.73, 0.025, self.mapTitle);
			for k=1,table.getn(self.masterText) do 
				renderText(0.26, self.textLinesPosHeightMaster[k],self.textFontSizeMaster, self.masterText[k]);
			end;
			setTextBold(false);
			renderText(0.265, 0.11, 0.024, g_i18n:getText("MBO_with_Text"));
			renderText(0.45, 0.11, 0.03, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MBO_Preview));
			renderText(0.265, 0.065, 0.024, g_i18n:getText("MBO_without_Text"));
			renderText(0.45, 0.065, 0.03, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MBO_Buy));
			setTextBold(true);
			renderText(0.60, 0.11, 0.03, "0 €");
			renderText(0.60, 0.065, 0.03, "0 €");
			setTextBold(false);
	end;
end;

MasterTriggerBuyableAllEvent = {};
MasterTriggerBuyableAllEvent_mt = Class(MasterTriggerBuyableAllEvent, Event);

InitEventClass(MasterTriggerBuyableAllEvent, "MasterTriggerBuyableAllEvent");

function MasterTriggerBuyableAllEvent:emptyNew()
    local self = Event:new(MasterTriggerBuyableAllEvent_mt);
    self.className = "MasterTriggerBuyableAllEvent";
    return self;
end;

function MasterTriggerBuyableAllEvent:new(object, without)
    local self = MasterTriggerBuyableAllEvent:emptyNew()
    self.object = object;
	self.without = without;
    return self;
end;

function MasterTriggerBuyableAllEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.without  = streamReadBool(streamId);
    self:run(connection);
end;

function MasterTriggerBuyableAllEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.without);
end;

function MasterTriggerBuyableAllEvent:run(connection)
  self.object:withoutMBO(self.without, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MasterTriggerBuyableAllEvent:new(self.object, self.without), nil, connection, self.object);
	end;
end;

function MasterTriggerBuyableAllEvent.sendEvent(object, without, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(MasterTriggerBuyableAllEvent:new(object, without), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(MasterTriggerBuyableAllEvent:new(object, without));
    end;
  end;
end;


