﻿--
--		<Attribute name="Buy_Objects" type="string" value=""/>					--Index zur Tg mit kaufbaren Objekten
--		<Attribute name="Buy_Triggers" type="string" value=""/>					--Index zur TG mit kaufbaren Triggern
--		<Attribute name="Buy_Triggers_Auto" type="boolean" value="true"/>		--Wenn true wird die TG automatisch ausgelsen, wenn Halen weg, dann jeder Index einzeln angeben
--		<Attribute name="Delete_Objects" type="string" value=""/>				--Index zur Tg mit verkaufbaren Objekten
--		<Attribute name="Delete_Triggers" type="string" value=""/>				--Index zur TG mit verkaufbaren Triggern
--		<Attribute name="Delete_Triggers_Auto" type="boolean" value="true"/>	--Wenn true wird die TG automatisch ausgelsen, wenn Halen weg, dann jeder Index einzeln angeben
--		<Attribute name="New_Carrer_Start" type="string" value=""/>				--Index zur TG mit dem neuen KarriereStart
--		<Attribute name="New_ResetPlaces" type="boolean" value="false"/>		--Ob neue ResetPlaces erstellt genutzt werden sollen
--		<Attribute name="New_StorePlaces" type="boolean" value="false"/>		--Ob neue StorePlaces erstellt genutzt werden sollen
--		<Attribute name="Number_new_ResetPlaces" type="integer" value="0"/>		--Anzahl der neuen ResetPlaces
--		<Attribute name="Number_new_StorePlaces" type="integer" value="0"/>		--Anzahl der neuen StorePlaces
--		<Attribute name="Object_Ident_Icon" type="integer" value="1"/>			--Identifizierung des Icons
--		<Attribute name="Preview_Sound" type="boolean" value="true"/>			--Ob bei Vorschau sound gespielt werden soll
--		<Attribute name="Preview_Time" type="float" value="10"/>				--Vorschau Zeit, mindestens 5 sek, max 30sek
--		<Attribute name="SoundFile" type="string" value=""/>					--Pfad zur eigenen Soundfile
--		<Attribute name="Sound_Allowed" type="boolean" value="true"/>			--Ob sound beim kauf gespielt werden soll
--		<Attribute name="Sound_is_01" type="boolean" value="false"/>			--Ob Sound1 gespielt werden soll
--		<Attribute name="Sound_is_02" type="boolean" value="false"/>			--Ob Sound2 gespielt werden soll
--		<Attribute name="Sound_is_03" type="boolean" value="true"/>				--Ob Sound3 gespielt werden soll
--		<Attribute name="TextName" type="string" value="MapBuyableObject01"/>	--Textname des Objekts in der XML
--		<Attribute name="Translate_Objects" type="string" value=""/>			--Index zur TG mit Objekten die nur in der Position verändert werden sollen
--		<Attribute name="onCreate" type="scriptCallback" value="MapBuyableObject.onCreateBuyableObject"/>  --Skript Callback
--		<Attribute name="xmlFilePath" type="string" value="map/buyable/buyableHelpText.xml"/>			--Pfad zur XML mit den Texten, ohne Namen der zip zur Map
--     
--	 			--Attribute when Translate_Objects, then Attribute added in the object whit new Position
--		<Attribute name="Rotation" type="string" value="0 90 0"/>
--		<Attribute name="Translation" type="string" value="0 0 3.5"/>
--
--   
--				--Attribute when Object has a Rotation in Game when buyed, like windmill. Attribute direct in the rotate object
--		<Attribute name="RotateX" type="float" value="0"/>
--		<Attribute name="RotateY" type="float" value="0"/>
--		<Attribute name="RotateZ" type="float" value="-0.0025"/>
--
--
--		MapBuyableObject
--@date: 02/02/2013
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0		release
--
--darf in jede Map eingebaut werden, MapBuyableObject.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission


	print("   Map: Buyable Objects (Buyable) v1.0  by Bluebaby210 loaded!");


iconNumber = 0;



---------------------------------------
function onCreateBuyableObject(self, id)
	--print("created buayableTrigger, id: ", id);
	local buyTrigger = BuyableObject:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(buyTrigger);
    buyTrigger:load(id);
    buyTrigger:register(true);
	table.insert(ObjectBuy.drawParts, buyTrigger);
end;

BuyableObject = {}
BuyableObject_directory = g_currentModDirectory;
local BuyableObject_mt = Class(BuyableObject, Object);

function BuyableObject:new(isServer, isClient)
    local self = Object:new(isServer, isClient, BuyableObject_mt);
    self.className = "BuyableObject";
    return self;
end;

function BuyableObject:load(id)

	self.triggerId = id
	addTrigger(self.triggerId, "TriggerCallback", self);
	self.playerInTrigger = false;
	self.showHud = false;
	self.warningMoney = false;
	self.backgroundHud = createImageOverlay(BuyableObject_directory.."buyable/New1.png");
	self.modNameHud = createImageOverlay(BuyableObject_directory.."buyable/modName.png");
	self.bankNoteHud = createImageOverlay(BuyableObject_directory.."buyable/icon.png");
	self.notEnoughMoney = createImageOverlay(BuyableObject_directory.."buyable/warning.png");
	self.headHudNew = createImageOverlay(BuyableObject_directory.."buyable/HeadHud.dds");
	self.timerMoneyWarning = false;

	self.objectIdentIcon = Utils.getNoNil(getUserAttribute(id, "Object_Ident_Icon"), 86547);
	self.buyableText = getUserAttribute(id, "TextName");
	
	self.soundForBuy = Utils.getNoNil(getUserAttribute(id, "Sound_Allowed"), false);
	self.soundBuyIs01 = Utils.getNoNil(getUserAttribute(id, "Sound_is_01"), false);
	self.soundBuyIs02 = Utils.getNoNil(getUserAttribute(id, "Sound_is_02"), false);
	self.soundBuyIs03 = Utils.getNoNil(getUserAttribute(id, "Sound_is_03"), false);
	self.soundPreview = Utils.getNoNil(getUserAttribute(id, "Preview_Sound"), false);
	self.previewTime = Utils.getNoNil(getUserAttribute(id, "Preview_Time"), nil);
	
	if self.previewTime ~= nil and self.previewTime > 0 then
		if self.previewTime < 5 then
			self.previewTime = 5000;
		elseif self.previewTime > 30 then
			self.previewTime = 30000;
		elseif self.previewTime > 5 and self.previewTime < 30 then
			self.previewTime = self.previewTime*1000;
		else
			self.previewTime = 10000;
		end;
	else
		self.previewTime = 10000;
	end;
	
	if self.soundPreview then
		self.soundFilePreview = Utils.getFilename(BuyableObject_directory.."sounds/preview.ogg");
		self.previewSound = createSample("BOPreview");
		loadSample(self.previewSound, self.soundFilePreview, false);
	end;

	if self.soundForBuy then
		self.buySoundFile = getUserAttribute(id, "SoundFile");	--string
			if self.buySoundFile ~= nil and string.len(self.buySoundFile) >= 1 then			
				self.soundFile = g_currentMission.missionInfo.baseDirectory..self.buySoundFile;
				self.mapSound = createSample("BOTrigger");
				loadSample(self.mapSound, self.soundFile, false);
				self.playing = false;
			elseif self.soundBuyIs01 then
				self.soundFile = Utils.getFilename(BuyableObject_directory.."sounds/BOS01.wav");
				self.mapSound = createSample("BOTrigger");
				loadSample(self.mapSound, self.soundFile, false);
				self.playing = false;
			elseif self.soundBuyIs02 then
				self.soundFile = Utils.getFilename(BuyableObject_directory.."sounds/BOS02.wav");
				self.mapSound = createSample("BOTrigger");
				loadSample(self.mapSound, self.soundFile, false);
				self.playing = false;
			elseif self.soundBuyIs03 then
				self.soundFile = Utils.getFilename(BuyableObject_directory.."sounds/BOS03.wav");
				self.mapSound = createSample("BOTrigger");
				loadSample(self.mapSound, self.soundFile, false);
				self.playing = false;
			else
				self.soundFile = Utils.getFilename(BuyableObject_directory.."sounds/BOS01.wav");
				self.mapSound = createSample("BOTrigger");
				loadSample(self.mapSound, self.soundFile, false);
				self.playing = false;			
			end;
	else
		self.playing = false;
	end;

	
	self.toBuy = 3;
	self.toDelete = 3;
	self.toTrigger = 3;
	self.toDeleteTrigger = 3;
	self.toTrans = 3;

	self.hasRotate = false;
	self.rotateObject = {};
	self.objectsToBuy = false;
	self.buyObjIndices = {};
	self.buyObjColliMask = {};
	self.buyObjBodyType = {};

	local indices = getUserAttribute(id, "Buy_Objects");
	if indices ~= nil and string.len(indices) >= 1 then
		self.objectsToBuy = true;
		local objects = Utils.splitString(" ", indices);		
		for k,v in pairs(objects) do
			local index = Utils.indexToObject(id, v);
			local child1 = getNumOfChildren(index);
			if child1 >= 1 then
				for a=1, child1 do
					local child1Insert = getChildAt(index, a - 1)
					table.insert(self.buyObjIndices, child1Insert);
					local child2 = getNumOfChildren(child1Insert);
					if child2 >= 1 then
						for a=1, child2 do
							local child2Insert = getChildAt(child1Insert, a - 1)
							table.insert(self.buyObjIndices, child2Insert);
							local child3 = getNumOfChildren(child2Insert);
							if child3 >= 1 then
								for a=1, child3 do
									local child3Insert = getChildAt(child2Insert, a - 1)
									table.insert(self.buyObjIndices, child3Insert);
									local child4 = getNumOfChildren(child3Insert);
									if child4 >= 1 then
										for a=1, child4 do
											local child4Insert = getChildAt(child3Insert, a - 1)
											table.insert(self.buyObjIndices, child4Insert);
											local child5 = getNumOfChildren(child4Insert);
											if child5 >= 1 then
												for a=1, child5 do
													local child5Insert = getChildAt(child4Insert, a - 1)
													table.insert(self.buyObjIndices, child5Insert);
													local child6 = getNumOfChildren(child5Insert);
													if child6 >= 1 then
														for a=1, child6 do
															local child6Insert = getChildAt(child5Insert, a - 1)
															table.insert(self.buyObjIndices, child6Insert);
															local child7 = getNumOfChildren(child6Insert);
															if child7 >= 1 then
																for a=1, child7 do
																	local child7Insert = getChildAt(child6Insert, a - 1)
																	table.insert(self.buyObjIndices, child7Insert);
																	local child8 = getNumOfChildren(child7Insert);
																	if child8 >= 1 then
																		for a=1, child8 do
																			local child8Insert = getChildAt(child7Insert, a - 1)
																			table.insert(self.buyObjIndices, child8Insert);
																			local child9 = getNumOfChildren(child8Insert);
																			if child9 >= 1 then
																				for a=1, child9 do
																					local child9Insert = getChildAt(child8Insert, a - 1)
																					table.insert(self.buyObjIndices, child9Insert);
																					local child10 = getNumOfChildren(child9Insert);
																					if child10 >= 1 then
																						for a=1, child10 do
																							local child10Insert = getChildAt(child9Insert, a - 1)
																							table.insert(self.buyObjIndices, child10Insert);
																						end;
																					end;
																				end;
																			end;
																		end;
																	end;
																end;
															end;
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
		
		for k,v in pairs(self.buyObjIndices) do
			self.buyObjBodyType[k] = getRigidBodyType(self.buyObjIndices[k]);
			self.buyObjColliMask[k] = getCollisionMask(self.buyObjIndices[k]);
			local rotX = Utils.getNoNil(getUserAttribute(self.buyObjIndices[k], "RotateX"), 0);
			local rotY = Utils.getNoNil(getUserAttribute(self.buyObjIndices[k], "RotateY"), 0);
			local rotZ = Utils.getNoNil(getUserAttribute(self.buyObjIndices[k], "RotateZ"), 0);
			if rotX ~= 0 or rotY ~= 0 or rotZ ~= 0 then
				table.insert(self.rotateObject, self.buyObjIndices[k]);
				self.hasRotate = true;
				if rotX ~= 0 then
					self.rotSpeedX = rotX;
				else
					self.rotSpeedX = 0;
				end;
				if rotY ~= 0 then
					self.rotSpeedY = rotY;
				else
					self.rotSpeedY = 0;
				end;
				if rotZ ~= 0 then
					self.rotSpeedZ = rotZ;
				else
					self.rotSpeedZ = 0;
				end;
			end;
			setVisibility(self.buyObjIndices[k], false);
			setCollisionMask(self.buyObjIndices[k], 0);
			setRigidBodyType(self.buyObjIndices[k], "NoRigidBody");
		end;

		
		self.toBuy = 0;
	else
		self.toBuy = 3;
	end;

	self.objectsToDelete = false;
	self.deleteObjIndices = {};
	
	local delete = getUserAttribute(id, "Delete_Objects");
	if delete ~= nil and string.len(delete) >= 1 then
		self.objectsToDelete = true;
		local objDel = Utils.splitString(" ", delete);
		for k,v in pairs(objDel) do
			local indexDel = Utils.indexToObject(id, v);
			local child1Del = getNumOfChildren(indexDel);
			if child1Del >= 1 then
				for a=1, child1Del do
					local child1DelInsert = getChildAt(indexDel, a - 1)
					table.insert(self.deleteObjIndices, child1DelInsert);
					local child2Del = getNumOfChildren(child1DelInsert);
					if child2Del >= 1 then
						for a=1, child2Del do
							local child2DelInsert = getChildAt(child1DelInsert, a - 1)
							table.insert(self.deleteObjIndices, child2DelInsert);
							local child3Del = getNumOfChildren(child2DelInsert);
							if child3Del >= 1 then
								for a=1, child3Del do
									local child3DelInsert = getChildAt(child2DelInsert, a - 1)
									table.insert(self.deleteObjIndices, child3DelInsert);
									local child4Del = getNumOfChildren(child3DelInsert);
									if child4Del >= 1 then
										for a=1, child4Del do
											local child4DelInsert = getChildAt(child3DelInsert, a - 1)
											table.insert(self.deleteObjIndices, child4DelInsert);
											local child5Del = getNumOfChildren(child4DelInsert);
											if child5Del >= 1 then
												for a=1, child5Del do
													local child5DelInsert = getChildAt(child4DelInsert, a - 1)
													table.insert(self.deleteObjIndices, child5DelInsert);
													local child6Del = getNumOfChildren(child5DelInsert);
													if child6Del >= 1 then
														for a=1, child6Del do
															local child6DelInsert = getChildAt(child5DelInsert, a - 1)
															table.insert(self.deleteObjIndices, child6DelInsert);
															local child7Del = getNumOfChildren(child6DelInsert);
															if child7Del >= 1 then
																for a=1, child7Del do
																	local child7DelInsert = getChildAt(child6DelInsert, a - 1)
																	table.insert(self.deleteObjIndices, child7DelInsert);
																	local child8Del = getNumOfChildren(child7DelInsert);
																	if child8Del >= 1 then
																		for a=1, child8Del do
																			local child8DelInsert = getChildAt(child7DelInsert, a - 1)
																			table.insert(self.deleteObjIndices, child8DelInsert);
																			local child9Del = getNumOfChildren(child8DelInsert);
																			if child9Del >= 1 then
																				for a=1, child9Del do
																					local child9DelInsert = getChildAt(child8DelInsert, a - 1)
																					table.insert(self.deleteObjIndices, child9DelInsert);
																					local child10Del = getNumOfChildren(child9DelInsert);
																					if child10Del >= 1 then
																						for a=1, child10Del do
																							local child10DelInsert = getChildAt(child9DelInsert, a - 1)
																							table.insert(self.deleteObjIndices, child10DelInsert);
																						end;
																					end;
																				end;
																			end;
																		end;
																	end;
																end;
															end;
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;

		for k,v in pairs(self.deleteObjIndices) do
			setVisibility(self.deleteObjIndices[k], true);
		end;
		

		self.toDelete = 1;
	else
		self.toDelete = 3;
	end;

	self.triggerToBuy = false;
	self.buyTriggerIndices = {};
	self.triggersTranslationX = {};
	self.triggersTranslationY = {};
	self.triggersTranslationZ = {};
	self.triggersColliMask = {};
	self.triggersScaleX = {};
	self.triggersScaleY = {};
	self.triggersScaleZ = {};
	self.triggersBodyType = {};
	self.triggerMainPart = {};
	
	local trigger = getUserAttribute(id, "Buy_Triggers");
	if trigger ~= nil and string.len(trigger) >= 1 then
	local buyTriggersAuto = Utils.getNoNil(getUserAttribute(id, "Buy_Triggers_Auto"), false);	--boolean
		self.triggerToBuy = true;
		if buyTriggersAuto then
			local objTriggers = Utils.splitString(" ", trigger);
			for k,v in pairs(objTriggers) do
				local indexTri = Utils.indexToObject(id, v);
				self.triggerMainPart[k] = Utils.indexToObject(id, v);
				local child1Tri = getNumOfChildren(indexTri);
				if child1Tri >= 1 then
					for a=1, child1Tri do
						local child1TriInsert = getChildAt(indexTri, a - 1)
						table.insert(self.buyTriggerIndices, child1TriInsert);
						local child2Tri = getNumOfChildren(child1TriInsert);
						if child2Tri >= 1 then
							for a=1, child2Tri do
								local child2TriInsert = getChildAt(child1TriInsert, a - 1)
								table.insert(self.buyTriggerIndices, child2TriInsert);
								local child3Tri = getNumOfChildren(child2TriInsert);
								if child3Tri >= 1 then
									for a=1, child3Tri do
										local child3TriInsert = getChildAt(child2TriInsert, a - 1)
										table.insert(self.buyTriggerIndices, child3TriInsert);
										local child4Tri = getNumOfChildren(child3TriInsert);
										if child4Tri >= 1 then
											for a=1, child4Tri do
												local child4TriInsert = getChildAt(child3TriInsert, a - 1)
												table.insert(self.buyTriggerIndices, child4TriInsert);
												local child5Tri = getNumOfChildren(child4TriInsert);
												if child5Tri >= 1 then
													for a=1, child5Tri do
														local child5TriInsert = getChildAt(child4TriInsert, a - 1)
														table.insert(self.buyTriggerIndices, child5TriInsert);
														local child6Tri = getNumOfChildren(child5TriInsert);
														if child6Tri >= 1 then
															for a=1, child6Tri do
																local child6TriInsert = getChildAt(child5TriInsert, a - 1)
																table.insert(self.buyTriggerIndices, child6TriInsert);
																local child7Tri = getNumOfChildren(child6TriInsert);
																if child7Tri >= 1 then
																	for a=1, child7Tri do
																		local child7TriInsert = getChildAt(child6TriInsert, a - 1)
																		table.insert(self.buyTriggerIndices, child7TriInsert);
																		local child8Tri = getNumOfChildren(child7TriInsert);
																		if child8Tri >= 1 then
																			for a=1, child8Tri do
																				local child8TriInsert = getChildAt(child7TriInsert, a - 1)
																				table.insert(self.buyTriggerIndices, child8TriInsert);
																				local child9Tri = getNumOfChildren(child8TriInsert);
																				if child9Tri >= 1 then
																					for a=1, child9Tri do
																						local child9TriInsert = getChildAt(child8TriInsert, a - 1)
																						table.insert(self.buyTriggerIndices, child9TriInsert);
																						local child10Tri = getNumOfChildren(child9TriInsert);
																						if child10Tri >= 1 then
																							for a=1, child10Tri do
																								local child10TriInsert = getChildAt(child9TriInsert, a - 1)
																								table.insert(self.buyTriggerIndices, child10TriInsert);
																							end;
																						end;
																					end;
																				end;
																			end;
																		end;
																	end;
																end;
															end;
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
			
		else
			local objTriggers = Utils.splitString(" ", trigger);
			for k,v in pairs(objTriggers) do
				self.buyTriggerIndices[k] = Utils.indexToObject(id, v);
				self.triggerMainPart[k] = Utils.indexToObject(id, v);
			end;
		end;

		for k,v in pairs(self.buyTriggerIndices) do
			self.triggersColliMask[k] = getCollisionMask(self.buyTriggerIndices[k]);
			self.triggersBodyType[k] = getRigidBodyType(self.buyTriggerIndices[k]);
			local x1, y1, z1 = getScale(self.buyTriggerIndices[k]);
			self.triggersScaleX[k] = x1;
			self.triggersScaleY[k] = y1;
			self.triggersScaleZ[k] = z1;
			local create = Utils.getNoNil(getUserAttribute(self.buyTriggerIndices[k], "onCreate"), nil);
			local orginal = "TipTrigger.onCreate";
			local appearsPDA = Utils.getNoNil(getUserAttribute(self.buyTriggerIndices[k], "appearsOnPDA"), false);
			if create ~= nil and create == orginal and appearsPDA then 
				self.triggersAppearsOnPDA = {};
				self.triggersStationName = {};
				self.triggersAppearsOnPDA[k] = Utils.getNoNil(getUserAttribute(self.buyTriggerIndices[k], "appearsOnPDA"), false);
				local name = Utils.getNoNil(getUserAttribute(self.buyTriggerIndices[k], "stationName"), "Station");
				self.triggersStationName[k] = name;
			end;
			setCollisionMask(self.buyTriggerIndices[k], 0);
		end;
		
		for k,v in pairs(self.triggerMainPart) do
			local x, y, z = getTranslation(self.triggerMainPart[k])
			self.triggersTranslationX[k] = x;
			self.triggersTranslationY[k] = y;
			self.triggersTranslationZ[k] = z;
		end;
		for i=1, table.getn(self.buyTriggerIndices) do
			local a = (table.getn(self.buyTriggerIndices) + 1) - i;
			setScale(self.buyTriggerIndices[a], 1, 1, 1);
		end;

		for i=1, table.getn(self.buyTriggerIndices) do
			local b = (table.getn(self.buyTriggerIndices) + 1) - i;
			setRigidBodyType(self.buyTriggerIndices[b], "Kinematic");
		end;
		
		for i=1, table.getn(self.triggerMainPart) do
			local d = (table.getn(self.triggerMainPart) + 1) - i;
			setTranslation(self.triggerMainPart[d], (self.triggersTranslationX[d] - 2000), (self.triggersTranslationY[d] -100), (self.triggersTranslationZ[d] - 2000)); 
		end;
		
		self.toTrigger = 0;
	else
		self.toTrigger = 3;
	end;

	self.triggerToDelete = false;
	self.deleteTriggerIndices = {};
	self.deleteTriTranslX = {};
	self.deleteTriTranslY = {};
	self.deleteTriTranslZ = {};
	
	local delTrigger = getUserAttribute(id, "Delete_Triggers");
	if delTrigger ~= nil and string.len(delTrigger) >= 1 then
	local delTriggersAuto = Utils.getNoNil(getUserAttribute(id, "Delete_Triggers_Auto"), false);	--boolean
		self.triggerToDelete = true;
		if delTriggersAuto then
			local objDelTriggers = Utils.splitString(" ", delTrigger);
			for k,v in pairs(objDelTriggers) do
				local indexDelTri = Utils.indexToObject(id, v);
				local child1DelTri = getNumOfChildren(indexDelTri);
				if child1DelTri >= 1 then
					for a=1, child1DelTri do
						local child1TriDelInsert = getChildAt(indexDelTri, a - 1)
						table.insert(self.deleteTriggerIndices, child1TriDelInsert);
						local child2DelTri = getNumOfChildren(child1TriDelInsert);
						if child2DelTri >= 1 then
							for a=1, child2DelTri do
								local child2DelTriInsert = getChildAt(child1TriDelInsert, a - 1)
								table.insert(self.deleteTriggerIndices, child2DelTriInsert);
								local child3DelTri = getNumOfChildren(child2DelTriInsert);
								if child3DelTri >= 1 then
									for a=1, child3DelTri do
										local child3DelTriInsert = getChildAt(child2DelTriInsert, a - 1)
										table.insert(self.deleteTriggerIndices, child3DelTriInsert);
										local child4DelTri = getNumOfChildren(child3DelTriInsert);
										if child4DelTri >= 1 then
											for a=1, child4DelTri do
												local child4DelTriInsert = getChildAt(child3DelTriInsert, a - 1)
												table.insert(self.deleteTriggerIndices, child4DelTriInsert);
												local child5DelTri = getNumOfChildren(child4DelTriInsert);
												if child5DelTri >= 1 then
													for a=1, child5DelTri do
														local child5DelTriInsert = getChildAt(child4DelTriInsert, a - 1)
														table.insert(self.deleteTriggerIndices, child5DelTriInsert);
														local child6DelTri = getNumOfChildren(child5DelTriInsert);
														if child6DelTri >= 1 then
															for a=1, child6DelTri do
																local child6DelTriInsert = getChildAt(child5DelTriInsert, a - 1)
																table.insert(self.deleteTriggerIndices, child6DelTriInsert);
																local child7DelTri = getNumOfChildren(child6DelTriInsert);
																if child7DelTri >= 1 then
																	for a=1, child7DelTri do
																		local child7DelTriInsert = getChildAt(child6DelTriInsert, a - 1)
																		table.insert(self.deleteTriggerIndices, child7DelTriInsert);
																		local child8DelTri = getNumOfChildren(child7DelTriInsert);
																		if child8DelTri >= 1 then
																			for a=1, child8DelTri do
																				local child8DelTriInsert = getChildAt(child7DelTriInsert, a - 1)
																				table.insert(self.deleteTriggerIndices, child8DelTriInsert);
																				local child9DelTri = getNumOfChildren(child8DelTriInsert);
																				if child9DelTri >= 1 then
																					for a=1, child9DelTri do
																						local child9DelTriInsert = getChildAt(child8DelTriInsert, a - 1)
																						table.insert(self.deleteTriggerIndices, child9DelTriInsert);
																						local child10DelTri = getNumOfChildren(child9DelTriInsert);
																						if child10DelTri >= 1 then
																							for a=1, child10DelTri do
																								local child10DelTriInsert = getChildAt(child9DelTriInsert, a - 1)
																								table.insert(self.deleteTriggerIndices, child10DelTriInsert);
																							end;
																						end;
																					end;
																				end;
																			end;
																		end;
																	end;
																end;
															end;
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
			
		else
			local objDelTriggers = Utils.splitString(" ", delTrigger);
			for k,v in pairs(objDelTriggers) do
				self.deleteTriggerIndices[k] = Utils.indexToObject(id, v);
			end;
		end;
		
		for k,v in pairs(self.deleteTriggerIndices) do
			local x2, y2, z2 = getTranslation(self.deleteTriggerIndices[k])
			self.deleteTriTranslX[k] = x2;
			self.deleteTriTranslY[k] = y2;
			self.deleteTriTranslZ[k] = z2;
			local createDel = Utils.getNoNil(getUserAttribute(self.deleteTriggerIndices[k], "onCreate"), nil);
			local orginalDel = "TipTrigger.onCreate";
			local appearsDelPDA = Utils.getNoNil(getUserAttribute(self.deleteTriggerIndices[k], "appearsOnPDA"), false);
			if createDel ~= nil and createDel == orginalDel and appearsDelPDA then 
				self.triggersDelAppearsOnPDA = {};
				self.triggersDelStationName = {};
				self.triggersDelAppearsOnPDA[k] = Utils.getNoNil(getUserAttribute(self.deleteTriggerIndices[k], "appearsOnPDA"), false);
				local name = Utils.getNoNil(getUserAttribute(self.deleteTriggerIndices[k], "stationName"), "Station");
				self.triggersDelStationName[k] = name;
			end;
		end;

		self.toDeleteTrigger = 1;
	else
		self.toDeleteTrigger = 3;
	end;		

	
	self.otherObjectsToBuy = false;
	self.otherObjBuyIndices = {};
	self.otherObjBuy = {};
	self.otherObjBuyColliMask = {};
	self.otherObjBuyBodyType = {};
	
	local buyObjects = getUserAttribute(id, "Other_Objects_Buy");
	if buyObjects ~= nil and string.len(buyObjects) >= 1 then
		self.otherObjectsToBuy = true;
		local otherObj = Utils.splitString(" ", buyObjects);
		for k,v in pairs(otherObj) do
			self.otherObjBuy[k] = Utils.indexToObject(id, v);
			local index = getNumOfChildren(self.otherObjBuy[k]);
			for a=1, index do
				local child = getChildAt(self.otherObjBuy[k], a - 1)
				table.insert(self.otherObjBuyIndices, child);
			end;
		end;
		
		if table.getn(self.otherObjBuyIndices) >= 1 then
			for k,v in pairs(self.otherObjBuyIndices) do
				self.otherObjBuyColliMask[k] = getCollisionMask(self.otherObjBuyIndices[k]);
				self.otherObjBuyBodyType[k] = getRigidBodyType(self.otherObjBuyIndices[k]);
				setVisibility(self.otherObjBuyIndices[k], false);
				setCollisionMask(self.otherObjBuyIndices[k], 0);
				setRigidBodyType(self.otherObjBuyIndices[k], "NoRigidBody");
			end;
		end;		
		self.toBuy = 0;
	end;
	
	
	self.otherObjectsToDelete = false;
	self.otherObjDelIndices = {};
	self.otherObjDel = {};
	
	local delObjects = getUserAttribute(id, "Other_Objects_Delete");
	if delObjects ~= nil and string.len(delObjects) >= 1 then
		self.otherObjectsToDelete = true;
		local otherDelObj = Utils.splitString(" ", delObjects);
		for k,v in pairs(otherDelObj) do
			self.otherObjDel[k] = Utils.indexToObject(id, v);
			local indexNew = getNumOfChildren(self.otherObjDel[k]);
			for a=1, indexNew do
				local childNew = getChildAt(self.otherObjDel[k], a - 1)
				table.insert(self.otherObjDelIndices, childNew);
			end;
		end;
		
		if table.getn(self.otherObjDelIndices) >= 1 then
			for k,v in pairs(self.otherObjDelIndices) do
				setVisibility(self.otherObjDelIndices[k], true);
			end;
		end;		
		self.toDelete = 1;
	end;

	self.objectsToTranslate = false;
	self.translateObjIndices = {};
	self.translateObjColliMask = {};
	self.translateObjBodyType = {};
	self.transObjTranslationX = {};
	self.transObjTranslationY = {};
	self.transObjTranslationZ = {};
	self.transObjRotationX = {};
	self.transObjRotationY = {};
	self.transObjRotationZ = {};
	self.transObjStartTrX = {};
	self.transObjStartTrY = {};
	self.transObjStartTrZ = {};
	self.transObjStartRoX = {};
	self.transObjStartRoY = {};
	self.transObjStartRoZ = {};
	
	
	local indexT = getUserAttribute(id, "Translate_Objects");
	if indexT ~= nil and string.len(indexT) >= 3 then
		self.objectsToTranslate = true;
		local objectsTrans = Utils.splitString(" ", indexT);
		for k,v in pairs(objectsTrans) do
			self.translateObjIndices[k] = Utils.indexToObject(id, v);
			self.translateObjColliMask[k] = getCollisionMask(self.translateObjIndices[k]);
			self.translateObjBodyType[k] = getRigidBodyType(self.translateObjIndices[k]);
			local stTraX, stTraY, stTraZ = getTranslation(self.translateObjIndices[k]);
			self.transObjStartTrX[k] = stTraX;
			self.transObjStartTrY[k] = stTraY;
			self.transObjStartTrZ[k] = stTraZ;
			local stRoX, stRoY, stRoZ = getRotation(self.translateObjIndices[k]);
			self.transObjStartRoX[k] = stRoX;
			self.transObjStartRoY[k] = stRoY;
			self.transObjStartRoZ[k] = stRoZ;
			local trans = getUserAttribute(self.translateObjIndices[k], "Translation");
				if trans ~= nil and string.len(trans) >= 5 then
					local transX, transY, transZ = Utils.getVectorFromString(getUserAttribute(self.translateObjIndices[k], "Translation"));
					self.transObjTranslationX[k] = transX;
					self.transObjTranslationY[k] = transY;
					self.transObjTranslationZ[k] = transZ;
				else
					local transX1, transY1, transZ1 = getTranslation(self.translateObjIndices[k])
					self.transObjTranslationX[k] = transX1;
					self.transObjTranslationY[k] = transY1;
					self.transObjTranslationZ[k] = transZ1;
				end;
			local rot = getUserAttribute(self.translateObjIndices[k], "Rotation");
				if rot ~= nil and string.len(rot) >= 5 then
					local rotX, rotY, rotZ = Utils.getVectorFromString(getUserAttribute(self.translateObjIndices[k], "Rotation"));
					self.transObjRotationX[k] = rotX;
					self.transObjRotationY[k] = rotY;
					self.transObjRotationZ[k] = rotZ;
				else
					local rotX1, rotY1, rotZ1 = getRotation(self.translateObjIndices[k])
					self.transObjRotationX[k] = rotX1;
					self.transObjRotationY[k] = rotY1;
					self.transObjRotationZ[k] = rotZ1;
				end;
		end;
		self.toTrans = 0;
	else
		self.toTrans = 3;
	end;
	
	self.newCarrerStartPoint = {};
	self.newStartPoint = false;
	self.saveGameLoad = false;
	
	local newPoint = getUserAttribute(id, "New_Carrer_Start");
	if newPoint ~= nil and string.len(newPoint) == 1 then
		local point = Utils.indexToObject(id, newPoint);
		self.newStartPoint = true;
		table.insert(self.newCarrerStartPoint, point);
	else
		self.newStartPoint = false;
	end;
	
	self.newResetPlaces = Utils.getNoNil(getUserAttribute(id, "New_ResetPlaces"), false);	--boolean
	self.newLoadSpawnPlaces = false;
	self.backupPlaces = {};
	
	if self.newResetPlaces then
		self.newAddedPlaces = Utils.getNoNil(getUserAttribute(id, "Number_new_ResetPlaces"), nil); --integer
		if self.newAddedPlaces ~= nil and self.newAddedPlaces > 0 then
			for i=1, table.getn(g_currentMission.loadSpawnPlaces) do
				self.backupPlaces[i] = g_currentMission.loadSpawnPlaces[i]
				self.backupPlaces[i].dirX = g_currentMission.loadSpawnPlaces[i].dirX;
				self.backupPlaces[i].dirPerpX = g_currentMission.loadSpawnPlaces[i].dirPerpX;
				self.backupPlaces[i].startX = g_currentMission.loadSpawnPlaces[i].startX;
				self.backupPlaces[i].dirY = g_currentMission.loadSpawnPlaces[i].dirY;
				self.backupPlaces[i].rotZ = g_currentMission.loadSpawnPlaces[i].rotZ;
				self.backupPlaces[i].width = g_currentMission.loadSpawnPlaces[i].width;
				self.backupPlaces[i].dirPerpZ = g_currentMission.loadSpawnPlaces[i].dirPerpZ;
				self.backupPlaces[i].rotX = g_currentMission.loadSpawnPlaces[i].rotX;
				self.backupPlaces[i].dirPerpY = g_currentMission.loadSpawnPlaces[i].dirPerpY;
				self.backupPlaces[i].startY = g_currentMission.loadSpawnPlaces[i].startY;
				self.backupPlaces[i].rotY = g_currentMission.loadSpawnPlaces[i].rotY;
				self.backupPlaces[i].startZ = g_currentMission.loadSpawnPlaces[i].startZ;
				self.backupPlaces[i].dirZ = g_currentMission.loadSpawnPlaces[i].dirZ;
			end;
			local numb = table.getn(g_currentMission.loadSpawnPlaces)
			self.orginalPlaces = numb - self.newAddedPlaces;
				for i=1, self.newAddedPlaces do
					table.remove(g_currentMission.loadSpawnPlaces, (self.orginalPlaces + 1));
				end;
			self.newLoadSpawnPlaces = true;
			self.toBuy = 0;
		end;
	end;
	
	self.newStorePlaces = Utils.getNoNil(getUserAttribute(id, "New_StorePlaces"), false);	--boolean
	self.newLoadStorePlaces = false;
	self.backupStorePlaces = {};
	
	if self.newStorePlaces then
		self.newAddedStorePlaces = Utils.getNoNil(getUserAttribute(id, "Number_new_StorePlaces"), nil); --integer
		if self.newAddedStorePlaces ~= nil and self.newAddedStorePlaces > 0 then
			for i=1, table.getn(g_currentMission.storeSpawnPlaces) do
				self.backupStorePlaces[i] = g_currentMission.storeSpawnPlaces[i]
				self.backupStorePlaces[i].rotX = g_currentMission.storeSpawnPlaces[i].rotX;
				self.backupStorePlaces[i].dirPerpX = g_currentMission.storeSpawnPlaces[i].dirPerpX;
				self.backupStorePlaces[i].startX = g_currentMission.storeSpawnPlaces[i].startX;
				self.backupStorePlaces[i].dirY = g_currentMission.storeSpawnPlaces[i].dirY;
				self.backupStorePlaces[i].rotZ = g_currentMission.storeSpawnPlaces[i].rotZ;
				self.backupStorePlaces[i].width = g_currentMission.storeSpawnPlaces[i].width;
				self.backupStorePlaces[i].startY = g_currentMission.storeSpawnPlaces[i].startY;
				self.backupStorePlaces[i].dirPerpY = g_currentMission.storeSpawnPlaces[i].dirPerpY;
				self.backupStorePlaces[i].dirPerpZ = g_currentMission.storeSpawnPlaces[i].dirPerpZ;
				self.backupStorePlaces[i].dirX = g_currentMission.storeSpawnPlaces[i].dirX;
				self.backupStorePlaces[i].rotY = g_currentMission.storeSpawnPlaces[i].rotY;
				self.backupStorePlaces[i].startZ = g_currentMission.storeSpawnPlaces[i].startZ;
				self.backupStorePlaces[i].dirZ = g_currentMission.storeSpawnPlaces[i].dirZ;
			end;
			local numb1 = table.getn(g_currentMission.storeSpawnPlaces)
			self.orginalStorePlaces = numb1 - self.newAddedStorePlaces;
				for i=1, self.newAddedStorePlaces do
					table.remove(g_currentMission.storeSpawnPlaces, (self.orginalStorePlaces + 1));
				end;
			self.newLoadStorePlaces = true;
			self.toBuy = 0;
		end;
	end;

	self.previewShow = false;
	self.buyShow = false;
	self.stateBuyPreview = 0;
	self.objectsBuyed = false;
	self.hasHourIncome = false;
	self.onlyOneTime = true;
	
	self.leng = getSystemLanguage();
	
	self.otherLeng = "aa";
	
	if self.leng ~= 1 and self.leng ~= 5 and self.leng ~= 0 then
		if self.leng == 2 then
			self.otherLeng = "jp";
			self.leng = 300000;
		elseif self.leng == 3 then
			self.otherLeng = "pl";
			self.leng = 300000;
		elseif self.leng == 4 then
			self.otherLeng = "cz";
			self.leng = 300000;
		elseif self.leng == 6 then
			self.otherLeng = "es";
			self.leng = 300000;
		elseif self.leng == 7 then
			self.otherLeng = "ru";
			self.leng = 300000;
		elseif self.leng == 8 then
			self.otherLeng = "it";
			self.leng = 300000;
		elseif self.leng == 9 then
			self.otherLeng = "pt";
			self.leng = 300000;
		elseif self.leng == 11 then
			self.otherLeng = "cn";
			self.leng = 300000;
		else
			self.leng = 0;
		end;
	end;
	
	self.xmlFileName = getUserAttribute(id, "xmlFilePath");
		if self.xmlFileName ~= nil and string.len(self.xmlFileName) >= 1 then
			self.fileName = g_currentMission.missionInfo.baseDirectory..self.xmlFileName;
			if fileExists(self.fileName) then
				local xml = loadXMLFile("buyableHelpText", self.fileName);

				self.newHudXml = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText..".HeadHudTetxure#path"), nil);
				self.hudPos = {};
				self.hudSize = {};
				local sizeHud = Utils.getNoNil(getXMLInt(xml, "MapBuyableObjects."..self.buyableText..".HeadHudPositionSize#size2"), nil);
				local posHud = Utils.getNoNil(getXMLInt(xml, "MapBuyableObjects."..self.buyableText..".HeadHudPositionSize#position2"), nil);
					if self.newHudXml ~= nil and string.len(self.newHudXml) >= 3 and posHud ~= nil and sizeHud ~= nil then
						self.headHudNew = createImageOverlay(g_currentMission.missionInfo.baseDirectory..self.newHudXml);
						for k=1, 2  do
							local pos = string.format("MapBuyableObjects."..self.buyableText..".HeadHudPositionSize#position%d", k);	
							self.hudPos[k] = getXMLFloat(xml, pos .. "");
							local size = string.format("MapBuyableObjects."..self.buyableText..".HeadHudPositionSize#size%d", k);	
							self.hudSize[k] = getXMLFloat(xml, size .. "");
						end;
					else 
						self.hudPos[1] = 0.287;
						self.hudPos[2] = 0.855;
						self.hudSize[1] = 0.308;
						self.hudSize[2] = 0.125;
					end;

				self.headlineTextBold = Utils.getNoNil(getXMLBool(xml, "MapBuyableObjects."..self.buyableText..".HeadLineColor#textBold"),true);
				self.descriptionTextBold = Utils.getNoNil(getXMLBool(xml, "MapBuyableObjects."..self.buyableText..".DescriptionColor#textBold"),false);
				self.headTextColor = {};
				self.descTextColor = {};
				local colorHead = Utils.getNoNil(getXMLInt(xml, "MapBuyableObjects."..self.buyableText..".HeadLineColor#number4"), nil);
				local colorText = Utils.getNoNil(getXMLInt(xml, "MapBuyableObjects."..self.buyableText..".DescriptionColor#number4"), nil);
				if (colorHead and colorText) ~= nil then
					for k=1, 4  do
						local colornumber = string.format("MapBuyableObjects."..self.buyableText..".HeadLineColor#number%d", k);	
						self.headTextColor[k] = getXMLInt(xml, colornumber .. "");
						local colornumberText = string.format("MapBuyableObjects."..self.buyableText..".DescriptionColor#number%d", k);	
						self.descTextColor[k] = getXMLInt(xml, colornumberText .. "");
					end;
				else
					for k=1, 3  do	
						self.descTextColor[k] = 0;
						self.headTextColor[k] = 0;
					end;
					table.insert(self.headTextColor, 1);
					table.insert(self.descTextColor, 1);
				end;
				self.priceObject = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".price_Object#price"), 25000);
				self.maxMinus = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".price_Object#maximalMinus"), -50000);
				self.hourIncome = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".price_Object#hourIncome"), 0);
				if self.hourIncome ~= 0 then
					self.hasHourIncome = true;
					g_currentMission.environment:addHourChangeListener(self);
				end;
				
				if self.leng == 300000 then	
					self.headlineText = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng.."#Headline"), nil);
					if self.headlineText == nil then
						self.leng = 0;
					end;
				end;
				if self.leng == 1 then
					self.headlineText = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText..".de#Headline"), "Error: Keine Überschrift!");
					self.headFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".de#fontSize"), 0.05);
					self.headPosHeight =  0.76;
					self.headPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".de#headlinePositionFromLeft"), 0.415);
					self.textFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".de.description#textFontSize"), 0.03);
					self.textPosHeight = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".de.description#textPositionHeight"), 0.65);
					self.textPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".de.description#textPositionFromLeft"), 0.30);

					self.descriptionText = {};
					self.textLinesPosHeight = {};
					--
					local k = 0;
					while true do
						local linesname = string.format("MapBuyableObjects."..self.buyableText..".de.line(%d)", k);
							if not hasXMLProperty(xml, linesname) then
								break;
							end;
						k = k + 1;
						self.descriptionText[k] = getXMLString(xml, linesname .. "#description");
						self.textLinesPosHeight[k] = self.textPosHeight - (self.textFontSize * k);
					end; 
				elseif self.leng == 5 then
					self.headlineText = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText..".fr#Headline"), "Erreur:Aucun titre trouvé!");
					self.headFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".fr#fontSize"), 0.05);
					self.headPosHeight = 0.76; 
					self.headPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".fr#headlinePositionFromLeft"), 0.415);
					self.textFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".fr.description#textFontSize"), 0.02);
					self.textPosHeight = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".fr.description#textPositionHeight"), 0.65);
					self.textPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".fr.description#textPositionFromLeft"), 0.30);
					self.descriptionText = {};
					self.textLinesPosHeight = {};
					local k = 0;
					while true do
						local linesname = string.format("MapBuyableObjects."..self.buyableText..".fr.line(%d)", k);
							if not hasXMLProperty(xml, linesname) then
								break;
							end;
						k = k + 1;
						self.descriptionText[k] = getXMLString(xml, linesname .. "#description");
						self.textLinesPosHeight[k] = self.textPosHeight - (self.textFontSize * k);
					end; 
				elseif self.leng == 300000 then
					self.headlineText = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng.."#Headline"), "Error: No headline found!!!");
					self.headFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng.."#fontSize"), 0.05);
					self.headPosHeight = 0.76; 
					self.headPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng.."#headlinePositionFromLeft"), 0.415);
					self.textFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng..".description#textFontSize"), 0.02);
					self.textPosHeight = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng..".description#textPositionHeight"), 0.65);
					self.textPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText.."."..self.otherLeng..".description#textPositionFromLeft"), 0.30);
					self.descriptionText = {};
					self.textLinesPosHeight = {};
					local k = 0;
					while true do
						local linesname = string.format("MapBuyableObjects."..self.buyableText.."."..self.otherLeng..".line(%d)", k);
							if not hasXMLProperty(xml, linesname) then
								break;
							end;
						k = k + 1;
						self.descriptionText[k] = getXMLString(xml, linesname .. "#description");
						self.textLinesPosHeight[k] = self.textPosHeight - (self.textFontSize * k);
					end; 
				else
					self.headlineText = Utils.getNoNil(getXMLString(xml, "MapBuyableObjects."..self.buyableText..".en#Headline"), "Error: No headline found!!!");
					self.headFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".en#fontSize"), 0.05);
					self.headPosHeight = 0.76; 
					self.headPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".en#headlinePositionFromLeft"), 0.415);
					self.textFontSize = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".en.description#textFontSize"), 0.02);
					self.textPosHeight = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".en.description#textPositionHeight"), 0.65);
					self.textPosLeft = Utils.getNoNil(getXMLFloat(xml, "MapBuyableObjects."..self.buyableText..".en.description#textPositionFromLeft"), 0.30);
					self.descriptionText = {};
					self.textLinesPosHeight = {};
					local k = 0;
					while true do
						local linesname = string.format("MapBuyableObjects."..self.buyableText..".en.line(%d)", k);
							if not hasXMLProperty(xml, linesname) then
								break;
							end;
						k = k + 1;
						self.descriptionText[k] = getXMLString(xml, linesname .. "#description");
						self.textLinesPosHeight[k] = self.textPosHeight - (self.textFontSize * k);
					end;
				end;
				
				if table.getn(self.descriptionText) == 0 then
					self.headPosLeft = 0.415;
					self.headPosHeight = 0.76;
					self.textFontSize = 0.03;
					self.textPosHeight = 0.5;
					self.textPosLeft = 0.325;
					self.descTextColor[1] = 1;
					self.headTextColor[1] = 1;
					self.descTextColor[2] = 0;
					self.headTextColor[2] = 0;
					self.descTextColor[3] = 0;
					self.headTextColor[3] = 0;
					self.descTextColor[4] = 1;
					self.headTextColor[4] = 1;
					self.headlineTextBold = true;
					self.descriptionTextBold = true;
					table.insert(self.descriptionText, "Error: No description given.");
					table.insert(self.textLinesPosHeight, (self.textPosHeight - self.textFontSize));
					table.insert(self.descriptionText, "Please check the path to XML");
					table.insert(self.textLinesPosHeight, (self.textPosHeight - (self.textFontSize * 2)));
					table.insert(self.descriptionText, "or specify a description.");
					table.insert(self.textLinesPosHeight, (self.textPosHeight - (self.textFontSize * 3)));
				end;
			else 
					self.headPosLeft = 0.415;
					self.headPosHeight = 0.76;
					self.headFontSize = 0.05
					self.textFontSize = 0.03;
					self.textPosHeight = 0.5;
					self.textPosLeft = 0.325;
					self.descTextColor = {};
					self.headTextColor = {};
					self.descriptionText = {};
					self.textLinesPosHeight = {};
					self.hudPos = {};
					self.hudSize = {};
					self.descTextColor[1] = 1;
					self.headTextColor[1] = 1;
					self.descTextColor[2] = 0;
					self.headTextColor[2] = 0;
					self.descTextColor[3] = 0;
					self.headTextColor[3] = 0;
					self.descTextColor[4] = 1;
					self.headTextColor[4] = 1;
					self.hudPos[1] = 0.287;
					self.hudPos[2] = 0.855;
					self.hudSize[1] = 0.308;
					self.hudSize[2] = 0.125;
					self.headlineTextBold = true;
					self.descriptionTextBold = true;
					self.headlineText = "Error";
					self.priceObject = 0;
					self.maxMinus = 0;
					self.hourIncome = 0;
					table.insert(self.descriptionText, "Error: XML not exist");
					table.insert(self.textLinesPosHeight, (self.textPosHeight - self.textFontSize));
					table.insert(self.descriptionText, "Please check the path to XML");
					table.insert(self.textLinesPosHeight, (self.textPosHeight - (self.textFontSize * 2)));
				print("WARNING: MapBuyableObjects can't load ", self.fileName, ": XML does not exist.");
				end;
	
		else 
				self.headPosLeft = 0.415;
				self.headPosHeight = 0.76;
				self.textFontSize = 0.03;
				self.textPosHeight = 0.5;
				self.textPosLeft = 0.325;
				self.descTextColor = {};
				self.headTextColor = {};
				self.descriptionText = {};
				self.textLinesPosHeight = {};
				self.hudPos = {};
				self.hudSize = {};
				self.descTextColor[1] = 1;
				self.headTextColor[1] = 1;
				self.descTextColor[2] = 0;
				self.headTextColor[2] = 0;
				self.descTextColor[3] = 0;
				self.headTextColor[3] = 0;
				self.descTextColor[4] = 1;
				self.headTextColor[4] = 1;
				self.hudPos[1] = 0.287;
				self.hudPos[2] = 0.855;
				self.hudSize[1] = 0.308;
				self.hudSize[2] = 0.125;
				self.headlineTextBold = true;
				self.descriptionTextBold = true;
				self.headlineText = "Error:";
				self.priceObject = 0;
				self.maxMinus = 0;
				self.hourIncome = 0;
				table.insert(self.descriptionText, "Error: No description given.");
				table.insert(self.textLinesPosHeight, (self.textPosHeight - self.textFontSize));
				table.insert(self.descriptionText, "Please check the path to XML");
				table.insert(self.textLinesPosHeight, (self.textPosHeight - (self.textFontSize * 2)));
				print("WARNING: MapBuyableObjects can't load ", self.xmlFileName, ": to short for a path in mods folder to a xml file");
		end;
	
	self.timerPreview = 0;
	self.startTimer = false;
	self.triggerAllowed = true;
	self.buyObject = false;
	self.difference = 0;
	self.pdaState = 0;
	self.helpHudState = 0;
	
	self.infoToOthersHUD = false;
	self.infoToOthers = false;
	self.hasPressedBuy = 0;
	self.firstMapStart = true;
	self.payedPrice = false;
	self.count = 0;

end;

function BuyableObject:delete()
		removeTrigger(self.triggerId);
		if self.soundPreview then
			stopSample(self.previewSound);
		end;
		if self.soundForBuy and self.playing  then
			stopSample(self.mapSound);
		end;

end;

function BuyableObject:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableObject:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableObject:readStream(streamId, connection)
	self.saveGameLoad = streamReadBool(streamId);
	self.objectsBuyed = streamReadBool(streamId);
	if not self.objectsBuyed then
		self:visibility(false, false, 3, true);
	end;

end;

function BuyableObject:writeStream(streamId, connection)
	streamWriteBool(streamId, self.saveGameLoad);
	streamWriteBool(streamId, self.objectsBuyed);
end;

function BuyableObject:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		self.count = self.count + 1;
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = true;
		end;
	elseif onLeave then
		self.count = self.count - 1;
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = false;
			if self.pdaState == 1 then
				g_currentMission.missionPDA.showPDA = true;
				self.pdaState = 0;
			end;
			if self.helpHudState == 1 then
				g_currentMission.showHelpText = true;
				self.helpHudState = 0;
			end;
		end;
	end;

end;

function BuyableObject:update(dt)

	if g_client ~= nil and g_client.netIsRunning then
		if self.firstMapStart then
			if self.objectsBuyed then
				self.saveGameLoad = true;
				self:visibility(true, false, 1, true);
				self.infoToOthers = false;
			end;
			self.firstMapStart = false;
		end;
	end;

	if self.infoToOthers and self.hasPressedBuy == 0 then
		self.timerPreview = self.timerPreview + dt;
		if self.timerPreview  >= 1 and self.timerPreview <= 7500 then
				self.infoToOthersHUD = true;
			elseif self.timerPreview >= 7500 then
				self.infoToOthersHUD = false;
				self.infoToOthers = false;
				self.hasPressedBuy = 0;
				self.timerPreview = 0;
			end;
	end;
	
	if self.objectsBuyed and self.hasRotate then
		if table.getn(self.rotateObject) ~= 0 then
			for i=1, table.getn(self.rotateObject) do
				rotate(self.rotateObject[i], (self.rotSpeedX*dt), (self.rotSpeedY*dt), (self.rotSpeedZ*dt));
			end;
		end;
	end;
	
	
	if (self.toBuy == 0 or self.toBuy == 3) and (self.toDelete == 1 or self.toDelete == 3) and (self.toTrigger == 0 or self.toTrigger == 3) and (self.toDeleteTrigger == 1 or self.toDeleteTrigger == 3) and (self.toTrans == 0 or self.toTrans == 3) then

			if self.triggerAllowed then
				if self.playerInTrigger and self.count == 1 then
					self.showHud = true;
					if g_currentMission.missionPDA.showPDA then
						self.pdaState = 1;
						g_currentMission.missionPDA.showPDA = false;
					end;
					if g_currentMission.showHelpText then
						self.helpHudState = 1;
						g_currentMission.showHelpText = false;
					end;
					if InputBinding.hasEvent(InputBinding.MBO_Preview) then
						self.startTimer = true;
					end;
					if InputBinding.hasEvent(InputBinding.MBO_Buy) then
						self.buyObject = true;
					end;
				end;
			end;
				
				
			if self.playerInTrigger == false then
				self.showHud = false;
			end;
				
			if self.startTimer then
				self.timerPreview = self.timerPreview + dt;
				--self.triggerAllowed = false;
				self.showHud = false;
					if self.timerPreview >= 1 and self.timerPreview <= self.previewTime then
						if self.onlyOneTime then
							self:visibility(false, true, 2);
							--self.onlyOneTime = false;
							if self.soundPreview then
								playSample(self.previewSound, 0, 1, 0);
							end;
						end;
					elseif self.timerPreview >= self.previewTime then
						self.timerPreview = 0;
						self.startTimer = false;
						--self.triggerAllowed = true;
						self:visibility(false, false, 2, true);
						self.onlyOneTime = true;
						if self.soundPreview then
							stopSample(self.previewSound);
						end;
					end;
			end;
				
			if self.buyObject then
				self.showHud = false;
				self.triggerAllowed = false;
				if (g_currentMission.missionStats.money - (self.priceObject)) >= (self.maxMinus) then
					self.hasPressedBuy = 2;
					self:visibility(true, false, 1);
					self.infoToOthers = false;
					if self.soundForBuy and self.playing == false then
						playSample(self.mapSound, 1, 1, 0);
						self.playing = true;
					end;
					self.buyObject = false;
				else
					self.difference = ((self.priceObject) + (self.maxMinus));	
					self.buyObject = false;
					self.timerMoneyWarning = true;
				end;
			end;
				
			if self.timerMoneyWarning then
				self.timerPreview = self.timerPreview + dt;
				if self.timerPreview >= 1 and self.timerPreview <= 6500 then
					self.warningMoney = true;
				elseif self.timerPreview >= 6500 then
					self.timerMoneyWarning = false;
					self.warningMoney = false;
					self.timerPreview = 0;
					self.triggerAllowed = true;
				end;
			end;
			
	end;

end;

function BuyableObject:visibility(buy, preview, buyOrPreview, noEventSend)

		self.buyShow = buy;
		self.previewShow = preview;
		self.stateBuyPreview = buyOrPreview;
		
		if not noEventSend then
			BuyableObjectEvent.sendEvent(self, buy, preview, buyOrPreview, noEventSend); --// das Eventscript aufrufen um alle Mitspieler zu informieren //
		end;

		--Update the Trigger, to setVisibility or not visibility the new trigger in PDA, only one time at game start.
		if self.previewShow == false and self.buyShow == false and self.stateBuyPreview == 3 then

			if self.triggersStationName ~= nil then
				for k,v in pairs(self.triggersStationName) do
					if self.triggersAppearsOnPDA[k] then
						for k,tipTrig in pairs(g_currentMission.tipTriggers) do
							if (tipTrig.stationName) == v then
								tipTrig.appearsOnPDA = false;
							end;
						end;
					end;
				end;
			end;

		end;
		
		if self.previewShow and self.stateBuyPreview == 2 then
				---- update um die Vorschau beim verlassen des spielers zurückzusetzen der gedrückt hat.
				self.startTimer = true;
				self.onlyOneTime = false;
				-----
				self.triggerAllowed = false;
				if self.triggerToBuy then
					for i=1, table.getn(self.triggerMainPart) do
						local d = (table.getn(self.triggerMainPart) + 1) - i;
						setTranslation(self.triggerMainPart[d], self.triggersTranslationX[d], self.triggersTranslationY[d], self.triggersTranslationZ[d]); 
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local b = (table.getn(self.buyTriggerIndices) + 1) - i;
						setRigidBodyType(self.buyTriggerIndices[b], self.triggersBodyType[b]);
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local c = (table.getn(self.buyTriggerIndices) + 1) - i;
						setCollisionMask(self.buyTriggerIndices[c], self.triggersColliMask[c]);
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local a = (table.getn(self.buyTriggerIndices) + 1) - i;
						setScale(self.buyTriggerIndices[a], self.triggersScaleX[a], self.triggersScaleY[a], self.triggersScaleZ[a]);
					end;
				end;
					
				if self.objectsToBuy then
					for k, v in pairs(self.buyObjIndices) do 
						setVisibility(self.buyObjIndices[k], true);
					end;
				end;
				if self.objectsToDelete then
					for k, v in pairs(self.deleteObjIndices) do 
						setVisibility(self.deleteObjIndices[k], false);
					end;
				end;
				if self.otherObjectsToBuy then
					for k, v in pairs(self.otherObjBuyIndices) do 
						setVisibility(self.otherObjBuyIndices[k], true);
					end;
				end;
				if self.otherObjectsToDelete then
					for k, v in pairs(self.otherObjDelIndices) do 
						setVisibility(self.otherObjDelIndices[k], false);
					end;
				end;
				if 	self.objectsToTranslate then
					for k,v in pairs(self.translateObjIndices) do
						setCollisionMask(self.translateObjIndices[k], 0);
						setRigidBodyType(self.translateObjIndices[k], "NoRigidBody")
					end;
					for k,v in pairs(self.translateObjIndices) do
						setTranslation(self.translateObjIndices[k], self.transObjTranslationX[k], self.transObjTranslationY[k], self.transObjTranslationZ[k]);
					end;
					for k,v in pairs(self.translateObjIndices) do
						setRotation(self.translateObjIndices[k], math.rad(self.transObjRotationX[k]), math.rad(self.transObjRotationY[k]), math.rad(self.transObjRotationZ[k]));
					end;
				end;
		elseif self.previewShow == false and self.stateBuyPreview == 2 then
				self.triggerAllowed = true;
					if self.triggerToBuy then						
						for i=1, table.getn(self.buyTriggerIndices) do
							local a = (table.getn(self.buyTriggerIndices) + 1) - i;
							setCollisionMask(self.buyTriggerIndices[k], 0);
						end;
					
						for i=1, table.getn(self.buyTriggerIndices) do
							local a = (table.getn(self.buyTriggerIndices) + 1) - i;
							setScale(self.buyTriggerIndices[a], 1, 1, 1);
						end;

						for i=1, table.getn(self.buyTriggerIndices) do
							local b = (table.getn(self.buyTriggerIndices) + 1) - i;
							setRigidBodyType(self.buyTriggerIndices[b], "Kinematic");
						end;
		
						for i=1, table.getn(self.triggerMainPart) do
							local d = (table.getn(self.triggerMainPart) + 1) - i;
							setTranslation(self.triggerMainPart[d], (self.triggersTranslationX[d] - 2000), (self.triggersTranslationY[d] -100), (self.triggersTranslationZ[d] - 2000)); 
						end;
					end;
					if self.objectsToBuy then
						for k, v in pairs(self.buyObjIndices) do 
							setVisibility(self.buyObjIndices[k], false);
						end;
					end;
					if self.objectsToDelete then
						for k, v in pairs(self.deleteObjIndices) do 
							setVisibility(self.deleteObjIndices[k], true);
						end;
					end;		

					if self.otherObjectsToBuy then
						for k, v in pairs(self.otherObjBuyIndices) do 
							setVisibility(self.otherObjBuyIndices[k], false);
						end;
					end;
					if self.otherObjectsToDelete then
						for k, v in pairs(self.otherObjDelIndices) do 
							setVisibility(self.otherObjDelIndices[k], true);
						end;
					end;		
					if 	self.objectsToTranslate then
						for k,v in pairs(self.translateObjIndices) do
							setTranslation(self.translateObjIndices[k], self.transObjStartTrX[k], self.transObjStartTrY[k], self.transObjStartTrZ[k]);
							setRotation(self.translateObjIndices[k], math.rad(self.transObjStartRoX[k]), math.rad(self.transObjStartRoY[k]), math.rad(self.transObjStartRoZ[k]));
						end;
						for k,v in pairs(self.translateObjIndices) do
							setRigidBodyType(self.translateObjIndices[k], self.translateObjBodyType[k])
							setCollisionMask(self.translateObjIndices[k], self.translateObjColliMask[k]);
						end;
					end;
		end;
			
		if self.buyShow and self.stateBuyPreview == 1 then
				self.showHud = false;
				self.triggerAllowed = false;
		
				if self.triggerToBuy then
					for i=1, table.getn(self.triggerMainPart) do
						local d = (table.getn(self.triggerMainPart) + 1) - i;
						setTranslation(self.triggerMainPart[d], self.triggersTranslationX[d], self.triggersTranslationY[d], self.triggersTranslationZ[d]); 
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local b = (table.getn(self.buyTriggerIndices) + 1) - i;
						setRigidBodyType(self.buyTriggerIndices[b], self.triggersBodyType[b]);
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local c = (table.getn(self.buyTriggerIndices) + 1) - i;
						setCollisionMask(self.buyTriggerIndices[c], self.triggersColliMask[c]);
					end;
					for i=1, table.getn(self.buyTriggerIndices) do
						local a = (table.getn(self.buyTriggerIndices) + 1) - i;
						setScale(self.buyTriggerIndices[a], self.triggersScaleX[a], self.triggersScaleY[a], self.triggersScaleZ[a]);
					end;
										
					if self.triggersStationName ~= nil then					
						for k,v in pairs(self.triggersStationName) do
							if self.triggersAppearsOnPDA[k] then
								for k,tipTrig in pairs(g_currentMission.tipTriggers) do
									if (tipTrig.stationName) == v then
										tipTrig.appearsOnPDA = true;
									end;
								end;
							end;
						end;
					end;
					
					self.triggerToBuy = false;
					self.toTrigger = 1;
				end;
				
				
				if self.objectsToBuy then
					for k, v in pairs(self.buyObjIndices) do
						setVisibility(self.buyObjIndices[k], true);
						setRigidBodyType(self.buyObjIndices[k], self.buyObjBodyType[k]);
						setCollisionMask(self.buyObjIndices[k], self.buyObjColliMask[k]);
					end;
					self.objectsToBuy = false;
					self.toBuy = 1;
				end;

				if self.objectsToDelete then
					for k, v in pairs(self.deleteObjIndices) do 
						setCollisionMask(self.deleteObjIndices[k], 0);
						setRigidBodyType(self.deleteObjIndices[k], "NoRigidBody");
						setVisibility(self.deleteObjIndices[k], false);
					end;
					self.objectsToDelete = false;
					self.toDelete = 0;
				end;
				
				if self.triggerToDelete then
					for k, v in pairs(self.deleteTriggerIndices) do
						setCollisionMask(self.deleteTriggerIndices[k], 0);
						setRigidBodyType(self.deleteTriggerIndices[k], "NoRigidBody");
						setScale(self.deleteTriggerIndices[k], 1, 1, 1);
					end;
					for k, v in pairs(self.deleteTriggerIndices) do
						setTranslation(self.deleteTriggerIndices[k], (self.deleteTriTranslX[k]-2000), (self.deleteTriTranslY[k]-100), (self.deleteTriTranslZ[k]));
					end;
					self.triggerToDelete = false;
					self.toDeleteTrigger = 0;

					if self.triggersDelStationName ~= nil then
						for k,v in pairs(self.triggersDelStationName) do
							if self.triggersDelAppearsOnPDA[k] then
								for k,tipTrig in pairs(g_currentMission.tipTriggers) do
									if (tipTrig.stationName) == v then
										tipTrig.appearsOnPDA = false;
									end;
								end;
							end;
						end;
					end;
					
				end;
				
				if self.otherObjectsToBuy then
					for k, v in pairs(self.otherObjBuyIndices) do 
						setVisibility(self.otherObjBuyIndices[k], true);
						setRigidBodyType(self.otherObjBuyIndices[k], self.otherObjBuyBodyType[k]);
						setCollisionMask(self.otherObjBuyIndices[k], self.otherObjBuyColliMask[k]);
					end;
					self.otherObjectsToBuy = false;
					self.toBuy = 1;
				end;
				
				if self.otherObjectsToDelete then
					for k, v in pairs(self.otherObjDelIndices) do 
						setCollisionMask(self.otherObjDelIndices[k], 0);
						setRigidBodyType(self.otherObjDelIndices[k], "NoRigidBody");
						setVisibility(self.otherObjDelIndices[k], false);
					end;
					self.otherObjectsToDelete = false;
					self.toDelete = 0;
				end;

				if 	self.objectsToTranslate then
					for k,v in pairs(self.translateObjIndices) do
						setCollisionMask(self.translateObjIndices[k], 0);
						setRigidBodyType(self.translateObjIndices[k], "NoRigidBody")
					end;
					for k,v in pairs(self.translateObjIndices) do
						setTranslation(self.translateObjIndices[k], self.transObjTranslationX[k], self.transObjTranslationY[k], self.transObjTranslationZ[k]);
						setRotation(self.translateObjIndices[k], math.rad(self.transObjRotationX[k]), math.rad(self.transObjRotationY[k]), math.rad(self.transObjRotationZ[k]));
					end;
					for k,v in pairs(self.translateObjIndices) do
						setRigidBodyType(self.translateObjIndices[k], self.translateObjBodyType[k])
						setCollisionMask(self.translateObjIndices[k], self.translateObjColliMask[k]);
					end;
					self.toTrans = 1;
					self.objectsToTranslate = false;
				end;
				
				if self.saveGameLoad then
					if self.newStartPoint then		
						for k,v in pairs(self.newCarrerStartPoint) do
							local x, y, z = getWorldTranslation(self.newCarrerStartPoint[k]);
							local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
							setTranslation(g_currentMission.player.rootNode, x, terrainHeight+2, z);
						end;
						self.newStartPoint = false;
					end;
				end;
				
				if self.newLoadSpawnPlaces then
					if self.newAddedPlaces ~= nil and self.newAddedPlaces > 0 then
						for i=1, table.getn(self.backupPlaces) do
							g_currentMission.loadSpawnPlaces[i] = self.backupPlaces[i]
							g_currentMission.loadSpawnPlaces[i].dirX = self.backupPlaces[i].dirX;
							g_currentMission.loadSpawnPlaces[i].dirPerpX = self.backupPlaces[i].dirPerpX;
							g_currentMission.loadSpawnPlaces[i].startX = self.backupPlaces[i].startX;
							g_currentMission.loadSpawnPlaces[i].dirY = self.backupPlaces[i].dirY;
							g_currentMission.loadSpawnPlaces[i].rotZ = self.backupPlaces[i].rotZ;
							g_currentMission.loadSpawnPlaces[i].width = self.backupPlaces[i].width;
							g_currentMission.loadSpawnPlaces[i].dirPerpZ = self.backupPlaces[i].dirPerpZ;
							g_currentMission.loadSpawnPlaces[i].rotX = self.backupPlaces[i].rotX;
							g_currentMission.loadSpawnPlaces[i].dirPerpY = self.backupPlaces[i].dirPerpY;
							g_currentMission.loadSpawnPlaces[i].startY = self.backupPlaces[i].startY;
							g_currentMission.loadSpawnPlaces[i].rotY = self.backupPlaces[i].rotY;
							g_currentMission.loadSpawnPlaces[i].startZ = self.backupPlaces[i].startZ;
							g_currentMission.loadSpawnPlaces[i].dirZ = self.backupPlaces[i].dirZ;
						end;
						
						for i=1, self.orginalPlaces do
							table.remove(g_currentMission.loadSpawnPlaces, 1);
						end;
						
						self.newLoadSpawnPlaces = false;
						self.toBuy = 1;						
					end;
				end;
	
				if self.newLoadStorePlaces then
					if self.newAddedStorePlaces ~= nil and self.newAddedStorePlaces > 0 then
						for i=1, table.getn(self.backupStorePlaces) do
							g_currentMission.storeSpawnPlaces[i] = self.backupStorePlaces[i]
							g_currentMission.storeSpawnPlaces[i].rotX = self.backupStorePlaces[i].rotX;
							g_currentMission.storeSpawnPlaces[i].dirPerpX = self.backupStorePlaces[i].dirPerpX;
							g_currentMission.storeSpawnPlaces[i].startX = self.backupStorePlaces[i].startX;
							g_currentMission.storeSpawnPlaces[i].dirY = self.backupStorePlaces[i].dirY;
							g_currentMission.storeSpawnPlaces[i].rotZ = self.backupStorePlaces[i].rotZ;
							g_currentMission.storeSpawnPlaces[i].width = self.backupStorePlaces[i].width;
							g_currentMission.storeSpawnPlaces[i].startY = self.backupStorePlaces[i].startY;
							g_currentMission.storeSpawnPlaces[i].dirPerpY = self.backupStorePlaces[i].dirPerpY;
							g_currentMission.storeSpawnPlaces[i].dirPerpZ = self.backupStorePlaces[i].dirPerpZ;
							g_currentMission.storeSpawnPlaces[i].dirX = self.backupStorePlaces[i].dirX;
							g_currentMission.storeSpawnPlaces[i].rotY = self.backupStorePlaces[i].rotY;
							g_currentMission.storeSpawnPlaces[i].startZ = self.backupStorePlaces[i].startZ;
							g_currentMission.storeSpawnPlaces[i].dirZ = self.backupStorePlaces[i].dirZ;
						end;

						for i=1, self.orginalStorePlaces do
							table.remove(g_currentMission.storeSpawnPlaces, 1);
						end;

						self.newLoadStorePlaces = false;
						self.toBuy = 1;
					end;
				end; 
				if not self.payedPrice and self.isServer and masterTriggerAllowed ~= 2 then
					g_currentMission:addSharedMoney(-(self.priceObject), "other");
					self.payedPrice = true;
				end;
			self.objectsBuyed = true;
			self.saveGameLoad = true;
			iconNumber = self.objectIdentIcon;
			self.infoToOthers = true;
		end;
		
end;

function BuyableObject:hourChanged()
	if self.isServer and self.objectsBuyed and self.hasHourIncome then
		g_currentMission:addSharedMoney((self.hourIncome), "other");
	end;
end;

function BuyableObject:draw()


		if self.showHud then
			renderOverlay(self.backgroundHud, 0.25, 0.01, 0.45, 1);
			renderOverlay(self.headHudNew, self.hudPos[1], self.hudPos[2], self.hudSize[1], self.hudSize[2]);
			renderOverlay(self.modNameHud, 0.36, 0.83, 0.18, 0.035);
			renderOverlay(self.bankNoteHud, 0.627, 0.88, 0.07, 0.11);
			setTextBold(self.headlineTextBold);
			setTextColor(self.headTextColor[1],self.headTextColor[2],self.headTextColor[3],self.headTextColor[4]);
			renderText(self.headPosLeft, self.headPosHeight, self.headFontSize, self.headlineText);
			setTextBold(self.descriptionTextBold);
			setTextColor(self.descTextColor[1],self.descTextColor[2],self.descTextColor[3],self.descTextColor[4]);
			for k=1,table.getn(self.descriptionText) do 
				renderText(self.textPosLeft, self.textLinesPosHeight[k],self.textFontSize, self.descriptionText[k]);
			end;
			setTextBold(true);
			setTextColor(1,0,0,1);
			setTextBold(false);
			setTextColor(0,0,0,1);
			renderText(0.265, 0.11, 0.024, g_i18n:getText("MBO_Preview_Text"));
			renderText(0.45, 0.11, 0.03, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MBO_Preview));
			renderText(0.265, 0.065, 0.024, g_i18n:getText("MBO_Buy_Text"));
			renderText(0.45, 0.065, 0.03, InputBinding.getKeyNamesOfDigitalAction(InputBinding.MBO_Buy));
			setTextBold(true);
			renderText(0.60, 0.11, 0.03, "0 €");
			renderText(0.58, 0.065, 0.03, self.priceObject.."€");
		end;
			
		if self.warningMoney then
			setTextBold(true);
			setTextColor(1,1,1,1);
			renderOverlay(self.notEnoughMoney, 0.3, 0.5, 0.4, 0.15);
			renderText(0.32, 0.61, 0.022, g_i18n:getText("Money"));
			renderText(0.32, 0.585, 0.022, g_i18n:getText("Money1"));
			renderText(0.32, 0.56, 0.022, g_i18n:getText("Money2"));
			setTextColor(1,0,0,1);
			renderText(0.39, 0.533, 0.022,"+"..tostring(self.difference).."€");
			setTextColor(1,1,1,1);
			setTextBold(false);
			renderText(0.32, 0.515, 0.015, g_i18n:getText("Money3"));
		end;

	
		if self.infoToOthersHUD then
			setTextBold(true);
			setTextColor(1,1,1,1);
			renderOverlay(self.notEnoughMoney, 0.39, 0.845, 0.4, 0.15);
			renderText(0.41, 0.955, 0.022, g_i18n:getText("infoToOthers1"));
			renderText(0.41, 0.932, 0.022, g_i18n:getText("infoToOthers2"));
			renderText(0.41, 0.909, 0.022, g_i18n:getText("infoToOthers3"));
			renderText(0.41, 0.886, 0.022, g_i18n:getText("infoToOthers4"));
			renderText(0.41, 0.863, 0.022, g_i18n:getText("infoToOthers5"));
		end;

end;

BuyableObjectEvent = {};
BuyableObjectEvent_mt = Class(BuyableObjectEvent, Event);
InitEventClass(BuyableObjectEvent, "BuyableObjectEvent");

function BuyableObjectEvent:emptyNew()
    local self = Event:new(BuyableObjectEvent_mt);
    self.className="BuyableObjectEvent";
    return self;
end;

function BuyableObjectEvent:new(object, buy, preview, buyOrPreview)
    local self = BuyableObjectEvent:emptyNew();
    self.object = object;
    self.buyShow = buy;
    self.previewShow = preview;
    self.stateBuyPreview = buyOrPreview;
    return self;
end;

function BuyableObjectEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.buyShow);
	streamWriteBool(streamId, self.previewShow);
	streamWriteInt8(streamId, self.stateBuyPreview);
end;

function BuyableObjectEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.buyShow  = streamReadBool(streamId);
    self.previewShow  = streamReadBool(streamId);
    self.stateBuyPreview = streamReadInt8(streamId);
    self:run(connection);
end;

function BuyableObjectEvent:run(connection)
  self.object:visibility(self.buyShow, self.previewShow, self.stateBuyPreview, true);
  if not connection:getIsServer() then 
      g_server:broadcastEvent(BuyableObjectEvent:new(self.object,self.buyShow, self.previewShow, self.stateBuyPreview), nil, connection, self.object);
  end;  
end;

function BuyableObjectEvent.sendEvent(object, buy, preview, buyOrPreview, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(BuyableObjectEvent:new(object, buy, preview, buyOrPreview), nil, nil, object);
    else 
      g_client:getServerConnection():sendEvent(BuyableObjectEvent:new(object, buy, preview, buyOrPreview));
    end;
  end;
end;
