--
-- Metal-Fach N267
-- Author: Burner
-- Date: 21.05.2012
--

MetalFach_N267 = {};

function MetalFach_N267.prerequisitesPresent(specializations)
	return true;
end;
function MetalFach_N267:load(xmlFile)
	self.toggleAdapter = SpecializationUtil.callSpecializationsFunction("toggleAdapter");
	self.toggleAdditionalBoards = SpecializationUtil.callSpecializationsFunction("toggleAdditionalBoards");
	self.toggleBackDoor = SpecializationUtil.callSpecializationsFunction("toggleBackDoor");
	
	self.backDoorAnimation = getXMLString(xmlFile, "vehicle.backDoorAnimation#animationName");
	self.backDoorActive = true;
	self.backDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backDoor#index"));
	
	self.additionalBoards = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.additionalBoards#index"));
    self.additionalBoardsActive = false;
	
	self.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.adapter#index"));
    self.adapterActive = true;
end;

function MetalFach_N267:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'adapter="'.. tostring(self.adapterActive) ..'" additionalBoards="'.. tostring(self.additionalBoardsActive) ..'"';
	return attributes, nil;
end;

function MetalFach_N267:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local adapterActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#adapter"), true);
		local additionalBoards = Utils.getNoNil(getXMLBool(xmlFile, key.."#additionalBoards"), false);
		self:toggleAdapter(adapterActive);
		self:toggleAdditionalBoards(additionalBoards);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function MetalFach_N267:delete()
end;

function MetalFach_N267:readStream(streamId, connection)
	self:toggleAdditionalBoards(streamReadBool(streamId), true);
	self:toggleAdapter(streamReadBool(streamId), true);
	self:toggleBackDoor(streamReadBool(streamId), true);
end;

function MetalFach_N267:writeStream(streamId, connection)
	streamWriteBool(streamId, self.additionalBoardsActive);
	streamWriteBool(streamId, self.adapterActive);
	streamWriteBool(streamId, self.backDoorActive);
end;

function MetalFach_N267:readUpdateStream(streamId, timestamp, connection)
end;

function MetalFach_N267:writeUpdateStream(streamId, connection, dirtyMask)
end;

function MetalFach_N267:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MetalFach_N267:keyEvent(unicode, sym, modifier, isDown)
end;

function MetalFach_N267:update(dt)
	setVisibility(self.additionalBoards, self.additionalBoardsActive);
    setVisibility(self.adapter, self.adapterActive);
	setVisibility(self.backDoor, not self.adapterActive);	
	
    if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEBACKDOOR) then
            self:toggleBackDoor(not self.backDoorActive);
        end;
		if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
			if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS) then
				self:toggleAdditionalBoards(not self.additionalBoardsActive);
			end;
			if InputBinding.hasEvent(InputBinding.WARFAMA_TOGGLEADAPTER) then
				self:toggleAdapter(not self.adapterActive);
			end;
		end;
    end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;
	elseif self.currentFillType == Fillable.FILLTYPE_MANURE then
		if self.adapterActive == false then
			self:toggleAdapter(true);
		end;
		if self.additionalBoardsActive == true then
			self:toggleAdditionalBoards(false);
		end;
	end
end;
function MetalFach_N267:onLeave()
end;
function MetalFach_N267:draw()
	if self.backDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_openBackDoor"),  InputBinding.WARFAMA_TOGGLEBACKDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_closeRightDoor"),  InputBinding.WARFAMA_TOGGLEBACKDOOR);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.additionalBoardsActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_hideAdditionalBoards"),  InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_showAdditionalBoards"),  InputBinding.WARFAMA_TOGGLEADDITIONALBOARDS);
		end;
		if self.adapterActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_hideAdapter"),  InputBinding.WARFAMA_TOGGLEADAPTER);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Warfama_showAdapter"),  InputBinding.WARFAMA_TOGGLEADAPTER);
		end;
	end;
end;

function MetalFach_N267:toggleAdditionalBoards(additionalBoardsState, noEventSend)
	SetAdditionalBoardsEvent.sendEvent(self, additionalBoardsState, noEventSend);
    self.additionalBoardsActive = additionalBoardsState;
end;


function MetalFach_N267:toggleAdapter(adapterState, noEventSend)
	SetAdapterEvent.sendEvent(self, adapterState, noEventSend);
    self.adapterActive = adapterState;
end;

function MetalFach_N267:toggleBackDoor(backDoorState,noEventSend)
	SetBackDoorEvent.sendEvent(self, backDoorState, noEventSend);
	if backDoorState then
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, -1, nil, true);
			self.backDoorActive = true;
		end;
	else
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, 1, nil, true);
			self.backDoorActive = false;
		end;
	end;
end;