--
-- controlledDrawBar
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-11-12
-- 
--[[
<controlledDrawBar startStepId="2" index="0>4|0" rotAxis="1" compJoint="1" >
	<step rot="-5"/>
	<step rot="0"/>
	<step rot="5"/>
</controlledDrawBar>	
]]--

controlledDrawBar = {};

function controlledDrawBar.prerequisitesPresent(specializations)
    return true;
end;

function controlledDrawBar:load(xmlFile)
	self.setDrawBar = SpecializationUtil.callSpecializationsFunction("setDrawBar");
	
	self.drawBar = {};
	self.drawBar.rotations = {};
	
	local i = 0;
	while true do
		local key = string.format("vehicle.controlledDrawBar.step(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local rot = getXMLFloat(xmlFile, key .. "#rot");
		if rot ~= nil then
			table.insert(self.drawBar.rotations, Utils.degToRad(rot));
			i = i + 1;
		else
			print("controlledDrawBar - Error: Invalid rotation");
			break;
		end;
	end;
	
	local startStepId = getXMLInt(xmlFile, "vehicle.controlledDrawBar#startStepId");
	if (startStepId == nil or (startStepId ~= nil and self.drawBar.rotations[startStepId] == nil)) then
		startStepId = 1;
	end;
	
	self.drawBar.currentId = startStepId;
	self.drawBar.comJoint = getXMLInt(xmlFile, "vehicle.controlledDrawBar#compJoint");
	self.drawBar.rotAxis = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.controlledDrawBar#rotAxis"), 1);
	self.drawBar.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlledDrawBar#index"));
end;

function controlledDrawBar:delete()
end;

function controlledDrawBar:readStream(streamId, connection)
	self:setDrawBar(streamReadInt8(streamId), true);
end;

function controlledDrawBar:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.drawBar.currentId);
end;

function controlledDrawBar:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentId = getXMLInt(xmlFile, key .. "#currentId");
	if currentId ~= nil then
		self:setDrawBar(currentId, true);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function controlledDrawBar:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentId="' .. self.drawBar.currentId .. '"';
	
	return attributes, nil;
end;

function controlledDrawBar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function controlledDrawBar:keyEvent(unicode, sym, modifier, isDown)
end;

function controlledDrawBar:update(dt)
	if self.attacherVehicle == nil then
		if self.drawBar.playerInRange and g_currentMission.controlPlayer and self.isClient then
			if g_gui.currentGui == nil and not g_currentMission.isPlayerFrozen then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					if self.drawBar.currentId + 1 <= table.getn(self.drawBar.rotations) then
						self:setDrawBar(self.drawBar.currentId + 1);
					end;
				elseif InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					if self.drawBar.currentId - 1 > 0 then
						self:setDrawBar(self.drawBar.currentId - 1);
					end;
				end;
			end;
			
			g_currentMission:addExtraPrintText(g_i18n:getText("drawBarTxt"));
		end;
	end;
end;

function controlledDrawBar:updateTick(dt)
	if self.attacherVehicle == nil then
		if self.drawBar.node ~= nil and g_currentMission.player ~= nil and self.isClient then
			local x, y, z = getWorldTranslation(self.drawBar.node);
			local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(x - px, y - py, z - pz);
			self.drawBar.playerInRange = distance < 1.5;
		end;
	end;
end;

function controlledDrawBar:draw()
end;

function controlledDrawBar:setDrawBar(id, noEventSend)
	self.drawBar.currentId = id;
	
	if self.drawBar.node ~= nil then
		local curRot = {getRotation(self.drawBar.node)};
		curRot[self.drawBar.rotAxis] = self.drawBar.rotations[self.drawBar.currentId];
		setRotation(self.drawBar.node, unpack(curRot));
	end;
	
	if self.isServer and self.drawBar.comJoint ~= nil then
		local joint = self.componentJoints[self.drawBar.comJoint];
		setJointFrame(joint.jointIndex, 0, joint.jointNode);
	end;
	
	setDrawBarEvent.sendEvent(self, id, noEventSend);
end;


setDrawBarEvent = {};
setDrawBarEvent_mt = Class(setDrawBarEvent, Event);

InitEventClass(setDrawBarEvent, "setDrawBarEvent");

function setDrawBarEvent:emptyNew()
    local self = Event:new(setDrawBarEvent_mt);
    self.className = "setDrawBarEvent";
	
    return self;
end;

function setDrawBarEvent:new(object, currentId)
    local self = setDrawBarEvent:emptyNew()
    self.object = object;
	self.currentId = currentId;
	
    return self;
end;

function setDrawBarEvent:readStream(streamId, connection)
    local currentId = streamReadInt32(streamId);
	self.currentId = streamReadInt8(streamId);
    self.object = networkGetObject(currentId);
	
    self:run(connection);
end;

function setDrawBarEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.currentId);
end;

function setDrawBarEvent:run(connection)
	self.object:setDrawBar(self.currentId, true);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(setDrawBarEvent:new(self.object, self.currentId), nil, connection, self.object);
	end;
end;

function setDrawBarEvent.sendEvent(object, currentId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setDrawBarEvent:new(object, currentId), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(setDrawBarEvent:new(object, currentId));
		end;
	end;
end;