--
-- ShoreFrontEstate
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
	
	source(g_modsDirectory .. "/Shore_Front_Estate_2013_by_SuperBrian91/Scripts/AdditionalMapFeatures/AdditionalMapFeatures.lua");
	
ShoreFrontEstate = {}

local ShoreFrontEstate_mt = Class(ShoreFrontEstate, Mission00);


function ShoreFrontEstate:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = ShoreFrontEstate_mt;
    end;
    local self = ShoreFrontEstate:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function ShoreFrontEstate:delete()
    ShoreFrontEstate:superClass().delete(self);
end;

function ShoreFrontEstate:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadmapFinished, self);
end;

function ShoreFrontEstate:loadmapFinished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen

	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("ShoreFrontEstate.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -144, -352, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
	self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -112, -381, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -110, -840, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    -- self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -276.5, 218, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- farm silos
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 110, 6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -3, 39, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
	-- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 888.8 , 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 142, -834, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory),  200, -906, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 234, -763, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    ShoreFrontEstate:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function ShoreFrontEstate:onStartMission()
    ShoreFrontEstate:superClass().onStartMission(self);
end;

function ShoreFrontEstate:mouseEvent(posX, posY, isDown, isUp, button)
    ShoreFrontEstate:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function ShoreFrontEstate:keyEvent(unicode, sym, modifier, isDown)
    ShoreFrontEstate:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function ShoreFrontEstate:update(dt)
    ShoreFrontEstate:superClass().update(self, dt);
end;

function ShoreFrontEstate:draw()
    ShoreFrontEstate:superClass().draw(self);
end;