-- upsidedown 01.01.2014



siloToSeedTrigger = {};

source("$dataS/scripts/vehicles/specializations/SowingMachineSetIsFillingEvent.lua");

function siloToSeedTrigger.prerequisitesPresent(specializations)
    return true;--SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function siloToSeedTrigger:readStream(streamId, connection)  

	
	
end;

function siloToSeedTrigger:writeStream(streamId, connection)


end;

function siloToSeedTrigger:load(xmlFile)
    self.setIsSowingMachineFilling = siloToSeedTrigger.setIsSowingMachineFilling;
    self.addSowingMachineFillTrigger = siloToSeedTrigger.addSowingMachineFillTrigger;
    self.removeSowingMachineFillTrigger = siloToSeedTrigger.removeSowingMachineFillTrigger;
    if fillLitersPerSecond==nil then
		self.fillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLitersPerSecond"), 500);
	end;
    self.isSowingMachineFilling = false;
   
    self.sowingMachineFillTriggers = {};
    self.sowingMachineFillActivatable = siloToSeedTriggerFillActivatable:new(self);
	
	self.siloToSeedTrigger_useSilo = false;
	self.siloToSeedTrigger_fillType = Fillable.FILLTYPE_SEEDS;
end;


function siloToSeedTrigger:update(dt)
		
	if self:getIsActiveForInput(true) then
		local pushEvent = false;
	
		if InputBinding.hasEvent(InputBinding.HorschSW3500S_triggerSilo) then
			self.siloToSeedTrigger_useSilo = not self.siloToSeedTrigger_useSilo;
			--pushEvent
			--print("useSilo: ",self.siloToSeedTrigger_useSilo);
			pushEvent = true;
		end;
		
		if self.fillLevel == 0 then
		
			if InputBinding.hasEvent(InputBinding.HorschSW3500S_triggerSeed) then
				local found = false;
				
				while not found do
					self.siloToSeedTrigger_fillType = self.siloToSeedTrigger_fillType + 1;
					if self.siloToSeedTrigger_fillType > Fillable.NUM_FILLTYPES then
						self.siloToSeedTrigger_fillType = 1;
					end;
					
					found = Utils.getNoNil(self.fillTypes[self.siloToSeedTrigger_fillType],false);
				end;
				
				pushEvent = true;
			end;
		else
			self.siloToSeedTrigger_fillType = self.currentFillType;
		end;
		
		
		if pushEvent then
			if g_server ~= nil then
				g_server:broadcastEvent(siloToSeedTrigger_Event:new(self), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(siloToSeedTrigger_Event:new(self));
			end;			
		end;
		
		--self.allowFillType
		
		-- for _,trigger in pairs(self.sowingMachineFillTriggers) do
			-- trigger.isSiloTrigger = self.siloToSeedTrigger_useSilo;
			-- trigger.fillType = self.siloToSeedTrigger_fillType;
		-- end;
		
	end;
end;

function siloToSeedTrigger:updateTick(dt)
	for _,trigger in pairs(self.sowingMachineFillTriggers) do
		trigger.isSiloTrigger = self.siloToSeedTrigger_useSilo;
		trigger.fillType = self.siloToSeedTrigger_fillType;
	end;

	 if self.isServer and self.isSowingMachineFilling then
		  local delta = 0;
		  if self.sowingMachineFillTrigger ~= nil then
			  delta = self.fillLitersPerSecond*dt*0.001;
			  delta = self.sowingMachineFillTrigger:fillSowingMachine(self, delta);
		  end

		  if delta <= 0 then
			  self:setIsSowingMachineFilling(false);
		  end;
	  end;
end;

function siloToSeedTrigger:draw()--print()
	if table.getn(self.sowingMachineFillTriggers) >0 then
		if self.fillLevel == 0 then
			g_currentMission:addHelpButtonText(g_i18n:getText("HorschSW3500S_nextSeed"), InputBinding.HorschSW3500S_triggerSeed)
			g_currentMission:addExtraPrintText(g_i18n:getText("HorschSW3500S_currSeed").." "..Fillable.fillTypeIntToName[self.siloToSeedTrigger_fillType])
		end;
		
		if self.siloToSeedTrigger_useSilo then
			g_currentMission:addHelpButtonText(g_i18n:getText("HorschSW3500S_siloOn"), InputBinding.HorschSW3500S_triggerSilo)
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("HorschSW3500S_siloOff"), InputBinding.HorschSW3500S_triggerSilo)
		end;
	end;
end;


function siloToSeedTrigger:delete()
		
end;



function siloToSeedTrigger:onAttach()
end; 	

function siloToSeedTrigger:onDetach()
	
end;

function siloToSeedTrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function siloToSeedTrigger:getSaveAttributesAndNodes(nodeIdent)
	
end;


function siloToSeedTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function siloToSeedTrigger:keyEvent(unicode, sym, modifier, isDown)
end;



function siloToSeedTrigger:setIsSowingMachineFilling(isFilling, noEventSend)
    SowingMachineSetIsFillingEvent.sendEvent(self, isFilling, noEventSend)
     if self.isSowingMachineFilling ~= isFilling then
        self.isSowingMachineFilling = isFilling;

        self.sowingMachineFillTrigger = nil;
        if isFilling then
            -- find the first trigger which is activable
            for i, trigger in ipairs(self.sowingMachineFillTriggers) do
                if trigger:getIsActivatable(self) then
                    self.sowingMachineFillTrigger = trigger;
                    break;
                end;
            end;
        end
    end;
end;

function siloToSeedTrigger:addSowingMachineFillTrigger(trigger)
    if table.getn(self.sowingMachineFillTriggers) == 0 then
        g_currentMission:addActivatableObject(self.sowingMachineFillActivatable);
    end;
    table.insert(self.sowingMachineFillTriggers, trigger);
	
	if trigger.orig_silo == nil then
		trigger.orig_silo = trigger.isSiloTrigger;
	end;
	if trigger.orig_fillType == nil then
		trigger.orig_fillType = trigger.fillType;
	end;
		
end;

function siloToSeedTrigger:removeSowingMachineFillTrigger(trigger)
    for i=1, table.getn(self.sowingMachineFillTriggers) do
        if self.sowingMachineFillTriggers[i] == trigger then
            table.remove(self.sowingMachineFillTriggers, i);
            break;
        end;
    end;
    if table.getn(self.sowingMachineFillTriggers) == 0 then
        if self.isServer then
            self:setIsSowingMachineFilling(false);
        end;
        g_currentMission:removeActivatableObject(self.sowingMachineFillActivatable);
    end;
	
	if trigger.orig_silo ~= nil then
		trigger.isSiloTrigger = trigger.orig_silo;
		trigger.fillType = trigger.orig_fillType;
	end;
end;

siloToSeedTriggerFillActivatable = {}
local siloToSeedTriggerFillActivatable_mt = Class(siloToSeedTriggerFillActivatable);

function siloToSeedTriggerFillActivatable:new(sowingMachine)
    local self = {};
    setmetatable(self, SowingMachineFillActivatable_mt);

    self.sowingMachine = sowingMachine;
    self.activateText = "unknown";
    self.getIsActivatable = siloToSeedTriggerFillActivatable.getIsActivatable;
	self.updateActivateText = siloToSeedTriggerFillActivatable.updateActivateText;
	self.drawActivate = siloToSeedTriggerFillActivatable.drawActivate;
	self.onActivateObject = siloToSeedTriggerFillActivatable.onActivateObject;
    return self;
end;


function siloToSeedTriggerFillActivatable:getIsActivatable()
    if self.sowingMachine:getIsActiveForInput() and self.sowingMachine.fillLevel < self.sowingMachine.capacity then
        -- find the first trigger which is activable
        for i,trigger in ipairs(self.sowingMachine.sowingMachineFillTriggers) do
            if trigger:getIsActivatable(self.sowingMachine) then
                self:updateActivateText();
                return true;
            end;
        end;
    end
    return false;
end;

function siloToSeedTriggerFillActivatable:onActivateObject()
	self.sowingMachine:setIsSowingMachineFilling(not self.sowingMachine.isSowingMachineFilling);
    self:updateActivateText();
    g_currentMission:addActivatableObject(self);
end;

function siloToSeedTriggerFillActivatable:drawActivate()
    -- TODO draw icon
end;

function siloToSeedTriggerFillActivatable:updateActivateText()
    if self.sowingMachine.isSowingMachineFilling then
        self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.sowingMachine.typeDesc);
    else
        self.activateText = string.format(g_i18n:getText("refill_OBJECT"), self.sowingMachine.typeDesc);
    end;
end;





  siloToSeedTrigger_Event = {};
  siloToSeedTrigger_Event_mt = Class(siloToSeedTrigger_Event, Event);
  
  InitEventClass(siloToSeedTrigger_Event, "siloToSeedTrigger_Event");
  
  function siloToSeedTrigger_Event:emptyNew()
      local self = Event:new(siloToSeedTrigger_Event_mt);
      return self;
  end;
  
  function siloToSeedTrigger_Event:new(object)
      local self = siloToSeedTrigger_Event:emptyNew()
      self.object = object;
	  
	  self.siloToSeedTrigger_fillType = object.siloToSeedTrigger_fillType;
	  self.siloToSeedTrigger_useSilo = object.siloToSeedTrigger_useSilo;
      
      return self;
  end;
  
  function siloToSeedTrigger_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteInt32(streamId, self.siloToSeedTrigger_fillType);
	  streamWriteBool(streamId, self.siloToSeedTrigger_useSilo);

  end;
  
  function siloToSeedTrigger_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.object = networkGetObject(id);
	  
	  self.siloToSeedTrigger_fillType = streamReadInt32(streamId);
      self.siloToSeedTrigger_useSilo = streamReadBool(streamId);	  
	  
      self:run(connection);
  end;
  
  
  
  function siloToSeedTrigger_Event:run(connection)
	  self.object.siloToSeedTrigger_fillType = self.siloToSeedTrigger_fillType;
	  self.object.siloToSeedTrigger_useSilo = self.siloToSeedTrigger_useSilo;
	 
      if not connection:getIsServer() then
          g_server:broadcastEvent(siloToSeedTrigger_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;