-- upsidedown 11.08.2013



raiseLowerOtherImplement = {};

function raiseLowerOtherImplement.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function raiseLowerOtherImplement:readStream(streamId, connection)  

	
	
end;

function raiseLowerOtherImplement:writeStream(streamId, connection)


end;

function raiseLowerOtherImplement:load(xmlFile)
	self.raiseLowerOtherImplementActive = false;
end;


function raiseLowerOtherImplement:update(dt)

	if self:getIsActiveForInput(true) then
		self.raiseLowerOtherImplementActive = false;
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.motor ~= nil then
				if #self.attacherVehicle.attachedImplements > 1 then
					self.raiseLowerOtherImplementActive = true;
				end;
			end;
		end;
		
		if self.raiseLowerOtherImplementActive then
			local doRaiseLower = false;
			if InputBinding.raiseLowerOtherImplement ~= nil then
				if InputBinding.hasEvent(InputBinding.raiseLowerOtherImplement) then
					doRaiseLower = true;
				end;
			elseif InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				doRaiseLower = true;
			end;
			if doRaiseLower then
				for k,implement in pairs(self.attacherVehicle.attachedImplements) do
					if implement.object ~= self then
						self.attacherVehicle:setJointMoveDown(implement.jointDescIndex, not implement.object:isLowered(false), false);
					end;
				end;
			end;
		end;
	end;	
end;


function raiseLowerOtherImplement:draw()
	if self.raiseLowerOtherImplementActive then
		if InputBinding.raiseLowerOtherImplement ~= nil then
			g_currentMission:addHelpButtonText("Vorderes Anbaugeraet", InputBinding.raiseLowerOtherImplement); 
		else
			g_currentMission:addHelpButtonText("Vorderes Anbaugeraet", InputBinding.IMPLEMENT_EXTRA3); 
		end;
	end;
end;


function raiseLowerOtherImplement:delete()
		
end;



function raiseLowerOtherImplement:onAttach()
end; 	

function raiseLowerOtherImplement:onDetach()
	
end;

function raiseLowerOtherImplement:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function raiseLowerOtherImplement:getSaveAttributesAndNodes(nodeIdent)
	
end;


function raiseLowerOtherImplement:mouseEvent(posX, posY, isDown, isUp, button)
end;

function raiseLowerOtherImplement:keyEvent(unicode, sym, modifier, isDown)
end;

