


MOLLE = {};

function MOLLE.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function MOLLE:load(xmlFile)

	self.spring = {};		
	self.spring.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MOLLE.spring(0)#index"));
	local x,y,z = getRotation(self.spring.node);
	
	self.spring.part = {x,y,z};
	self.spring.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MOLLE.spring(0)#part"));
	x,y,z = getTranslation(self.spring.part);
	
	self.spring.fixPoint = {x,y,z};
	self.spring.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MOLLE.spring(0)#fixPoint"));
	
	local ax, ay, az = getWorldTranslation(self.spring.part);
	local bx, by, bz = getWorldTranslation(self.spring.fixPoint);		
	self.spring.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.spring.target = {x,y,z};
	self.spring.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MOLLE.spring(0)#target"));
	
end;	
	

function MOLLE:delete()
end;

function MOLLE:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MOLLE:keyEvent(unicode, sym, modifier, isDown)
end;

function MOLLE:update(dt)
	--if self:getIsActive() then		
		if self.spring.target ~= nil then		
			local ax, ay, az = getWorldTranslation(self.spring.node);
			local bx, by, bz = getWorldTranslation(self.spring.target);
			local x, y, z = worldDirectionToLocal(getParent(self.spring.node), bx-ax, by-ay, bz-az);
			
			local upX, upY, upZ = 0,1,0;
			if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
				-- direction and up is parallel
				upY = 0;
				if y > 0 then
					upZ = 1;
				else
					upZ = -1;
				end;
			end;
			
			setDirection(self.spring.node, x, y, z, upX, upY, upZ);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.spring.part, 0, 0, distance-self.spring.distance);		
		end;		
	--end;
end;

function MOLLE:draw()
end;

function MOLLE:onAttach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-65), Utils.degToRad(65));	
end;

function MOLLE:onDetach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-8), Utils.degToRad(8));	
end;

function MOLLE:onLeave()
end;

function MOLLE:onDeactivate()
end;

function MOLLE:onDeactivateSounds()
end;


