-- AxleTrailer
-- 
--
-- @ Autor  FireAndIce (www.bm-modding.de)
-- @ Last Edit  20/12/2012

AxleTrailer = {};

function AxleTrailer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations); 
end;

function AxleTrailer:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
		

end;

function AxleTrailer:delete()
end;

function AxleTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AxleTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function AxleTrailer:update(dt)
	if self:getIsActive() and self.movingDirection ~= 0 then
		xr1,_,_ = getRotation(self.axle1);
		xr2,_,_ = getRotation(self.axle2);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].repr);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].repr);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].repr);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].repr);
		self.newRot1 = zrw1 - xr1;
		self.newRot2 = zrw3 - xr2;
		setRotation(self.wheels[1].repr, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].repr, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].repr, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].repr, xrw4,yrw4,self.newRot2)
	end;
	
		   
	-- setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
end;

function AxleTrailer:updateTick(dt)

end;

function AxleTrailer:draw()
		
end;

function AxleTrailer:onAttach()

end;

function AxleTrailer:onDetach()
end;