--
-- Fliegl271Bull
-- Specialization for Fliegl271Bull
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		30/10/12
-- @version:	v3.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--				v3.0 - ls13
--
-- free for noncommerical-usage
--

Fliegl271Bull = {};

function Fliegl271Bull.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Fliegl271Bull:load(xmlFile)
	
	self.setIsBoardwallVisible = SpecializationUtil.callSpecializationsFunction("setIsBoardwallVisible");	
	
	self.boardWall = {};
	self.boardWall.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.boardWall#node"));
	self.boardWall.addCapacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.boardWall#addCapacity"), 1500);
	self.boardWall.isVisible = true;	
	local fillType = Fillable.fillTypeIntToName[Fillable.FILLTYPE_WHEAT];
	local curve = self.fillPlanes[fillType].nodes[1].animCurve;
	self.boardWall.maxY = curve.keyframes[table.getn(curve.keyframes)].sy;
	self.boardWall.minY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.boardWall#y"), 0);
	self.capacity = self.capacity + self.boardWall.addCapacity;
	self.capacityBackup = self.capacity;
end;

function Fliegl271Bull:delete()
end;

function Fliegl271Bull:readStream(streamId, connection)
	self:setIsBoardwallVisible(streamReadBool(streamId), true);
end;

function Fliegl271Bull:writeStream(streamId, connection)
	streamWriteBool(streamId, self.boardWall.isVisible);
end;

function Fliegl271Bull:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fliegl271Bull:keyEvent(unicode, sym, modifier, isDown)
end;

function Fliegl271Bull:update(dt)

	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.fillLevel < 0.01 then
				if InputBinding.hasEvent(InputBinding.FLIEGLBULL_DISABLE_BOARDWALL) then
					self:setIsBoardwallVisible(not self.boardWall.isVisible);
				end;
			end;
		end;
	end;
end;

function Fliegl271Bull:updateTick(dt)
end;

function Fliegl271Bull:draw()
	if self.fillLevel < 0.01 then
		if self.boardWall.isVisible then
			g_currentMission:addHelpButtonText(g_i18n:getText("FLIEGLBULL_UNDOCK_WALL"), InputBinding.FLIEGLBULL_DISABLE_BOARDWALL);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("FLIEGLBULL_DOCK_WALL"), InputBinding.FLIEGLBULL_DISABLE_BOARDWALL);
		end;
	end;
end;

function Fliegl271Bull:setIsBoardwallVisible(isVisible, noEventSend)
	BoardwallEvent.sendEvent(self, isVisible, noEventSend);	
	self.boardWall.isVisible = isVisible;
	setVisibility(self.boardWall.node, isVisible);
	local newY = self.boardWall.minY;
	if isVisible then
		self.capacity = self.capacityBackup;
		newY = self.boardWall.maxY;
	else
		self.capacity = self.capacityBackup - self.boardWall.addCapacity;
	end;
	
	for _, fillplane in pairs(self.fillPlanes) do
		for _, node in pairs(fillplane.nodes) do
			node.animCurve.keyframes[table.getn(node.animCurve.keyframes)].sy = newY;
		end;	
	end;
	
	if self.fillLevel > 0 then
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
end;

function Fliegl271Bull:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isVisible = Utils.getNoNil(getXMLBool(xmlFile, key.."#isBoardwallVisible"), true);		
		self:setIsBoardwallVisible(isVisible, true);
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function Fliegl271Bull:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isBoardwallVisible="'.. tostring(self.boardWall.isVisible) .. '"';
    return attributes, nil;
end;



--
-- BoardwallEvent
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		30/10/12
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
-- 				v2.0 - ls13
--
-- free for noncommerical-usage
--

BoardwallEvent = {};
BoardwallEvent_mt = Class(BoardwallEvent, Event);

InitEventClass(BoardwallEvent, "BoardwallEvent");

function BoardwallEvent:emptyNew()
    local self = Event:new(BoardwallEvent_mt);
    return self;
end;

function BoardwallEvent:new(vehicle, isVisible)
    local self = BoardwallEvent:emptyNew()
    self.vehicle = vehicle;
	self.isVisible = isVisible;
    return self;
end;

function BoardwallEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isVisible = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BoardwallEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isVisible);
end;

function BoardwallEvent:run(connection)
	self.vehicle:setIsBoardwallVisible(self.isVisible, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(BoardwallEvent:new(self.vehicle, self.isVisible), nil, connection, self.vehicle);
	end;
end;

function BoardwallEvent.sendEvent(vehicle, isVisible, noEventSend)
	if vehicle.boardWall.isVisible ~= isVisible then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(BoardwallEvent:new(vehicle, isVisible), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(BoardwallEvent:new(vehicle, isVisible));
			end;
		end;
	end;
end;