SetIsPickupDownEvent = {};
SetIsPickupDownEvent_mt = Class(SetIsPickupDownEvent, Event);

InitEventClass(SetIsPickupDownEvent, "SetIsPickupDownEvent");

function SetIsPickupDownEvent:emptyNew()
    local self = Event:new(SetIsPickupDownEvent_mt);
    self.className="SetIsPickupDownEvent";
    return self;
end;

function SetIsPickupDownEvent:new(object, isDown)
    local self = SetIsPickupDownEvent:emptyNew()
    self.object = object;
	self.isDown = isDown;
    return self;
end;

function SetIsPickupDownEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDown = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetIsPickupDownEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isDown);
end;

function SetIsPickupDownEvent:run(connection)
    self.object:setIsPickupDown(self.isDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetIsPickupDownEvent:new(self.object, self.isDown), nil, connection, self.object);
    end;
end;

function SetIsPickupDownEvent.sendEvent(vehicle, isDown, noEventSend)
    if isDown ~= vehicle.pickup.isDown then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetIsPickupDownEvent:new(vehicle, isDown), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetIsPickupDownEvent:new(vehicle, isDown));
            end;
        end;
    end;
end;

