--
-- DustParticle
-- Specialization for DustParticle
--
-- @author  Geri-G
-- @date  02/08/10
--

DustParticle = {};

function DustParticle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function DustParticle:load(xmlFile)
	local i = 0;
	self.particles = {};
	self.particelActiv = false;
	while true do
		local baseString = string.format("vehicle.dustParticles.dustParticle(%d)",i);
		local entry = {};
		
		local node = getXMLString(xmlFile,baseString.."#node");
		if node == nil then
			break;
		end;

		Utils.loadParticleSystem(xmlFile, entry, baseString, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
		table.insert(self.particles,entry);
		i= i+1;
	end;
	self.Timer = -1;
end;

function DustParticle:delete()
	for k,v in pairs(self.particles) do
		Utils.deleteParticleSystem(v);
	end;
end;

function DustParticle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DustParticle:keyEvent(unicode, sym, modifier, isDown)
end;

function DustParticle:update(dt)	
	if self:getIsActive() then
		particelActiv = false;
		if self.AttachedBales ~= nil then
			if self.lastSpeed*3600 > 30 and table.getn(self.AttachedBales) > 0  then
				particelActiv = true;
				self.Timer = 1800;
			elseif self.lastSpeed*3600 > 30 and table.getn(self.AttachedBales) == 0 then
				if self.Timer >0 then
					self.Timer = self.Timer-dt;
					particelActiv = true;
				elseif self.Timer <= 0 and self.Timer ~= -1 then
					self.Timer = -1
					particelActiv = false;
				end;
			end;
		end;
		for k,v in pairs(self.particles) do
			Utils.setEmittingState(v, particelActiv);
		end;
	else
		for k,v in pairs(self.particles) do
			Utils.setEmittingState(v, false);
		end;
	end;	
end;

function DustParticle:draw()
end;


function DustParticle:onAttach(attacherVehicle)
end;

function DustParticle:onDetach()

end;




