SetPDFEvent = {};
SetPDFEvent_mt = Class(SetPDFEvent, Event);

InitEventClass(SetPDFEvent, "SetPDFEvent");

function SetPDFEvent:emptyNew()
    local self = Event:new(SetPDFEvent_mt);
    self.className="SetPDFEvent";
    return self;
end;

function SetPDFEvent:new(vehicle, PDF)
    local self = SetPDFEvent:emptyNew()
    self.vehicle = vehicle;
	self.PDF = PDF;
    return self;
end;

function SetPDFEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.PDF = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPDFEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.PDF);
end;

function SetPDFEvent:run(connection)   
	self.vehicle:setPDF(self.PDF, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPDFEvent:new(vehicle, self.PDF), nil, connection, self.vehicle);
    end;
end;

function SetPDFEvent.sendEvent(vehicle, PDF, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPDFEvent:new(vehicle, PDF), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPDFEvent:new(vehicle, PDF));
		end;
	end;
end;