SetDiminuerVitesseTapisEvent = {};
SetDiminuerVitesseTapisEvent_mt = Class(SetDiminuerVitesseTapisEvent, Event);

InitEventClass(SetDiminuerVitesseTapisEvent, "SetDiminuerVitesseTapisEvent");

function SetDiminuerVitesseTapisEvent:emptyNew()
    local self = Event:new(SetDiminuerVitesseTapisEvent_mt);
    self.className="SetDiminuerVitesseTapisEvent";
    return self;
end;

function SetDiminuerVitesseTapisEvent:new(vehicle, diminuerVitesseTapis)
    local self = SetDiminuerVitesseTapisEvent:emptyNew()
    self.vehicle = vehicle;
	self.diminuerVitesseTapis = diminuerVitesseTapis;
    return self;
end;

function SetDiminuerVitesseTapisEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.diminuerVitesseTapis = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDiminuerVitesseTapisEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.diminuerVitesseTapis);
end;

function SetDiminuerVitesseTapisEvent:run(connection)
	self.vehicle:setDiminuerVitesseTapis(self.diminuerVitesseTapis, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDiminuerVitesseTapisEvent:new(self.vehicle, self.diminuerVitesseTapis), nil, connection, self.vehicle);
    end;
end;

function SetDiminuerVitesseTapisEvent.sendEvent(vehicle, diminuerVitesseTapis, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDiminuerVitesseTapisEvent:new(vehicle, diminuerVitesseTapis), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDiminuerVitesseTapisEvent:new(vehicle, diminuerVitesseTapis));
		end;
	end;
end;
