LaCampagne = {};

function LaCampagne.prerequisitesPresent(specializations)
    return true;
end;

function LaCampagne:load(xmlFile)

		-- Tapis --
    self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.speed = 0;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	self.hayBase.offset = 0;
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);

		-- Porte --
	self.setPorte = SpecializationUtil.callSpecializationsFunction("setPorte");				
	self.PorteAnimation = getXMLString(xmlFile, "vehicle.Porte#animationName");
	self.Porte = false;
	
		-- Echelle --	
	self.setEchelle = SpecializationUtil.callSpecializationsFunction("setEchelle");				
	self.EchelleAnimation = getXMLString(xmlFile, "vehicle.Echelle#animationName");
	self.Echelle = false;

		-- Filet --
	self.Filet = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Filet#index"));
	self.setFilet1 = SpecializationUtil.callSpecializationsFunction("setFilet1");
	self.Filet1 = false;
	
		-- Vitesse Tapis Variable --
	self.setAugmenterVitesseTapis = SpecializationUtil.callSpecializationsFunction("setAugmenterVitesseTapis");
	self.setDiminuerVitesseTapis = SpecializationUtil.callSpecializationsFunction("setDiminuerVitesseTapis");
	self.augmenterVitesseTapis = false;
	self.diminuerVitesseTapis = false;
	
		-- Declaration des diffrents stades de vitesse --
	self.VITESSETAPIS_0 = 0;
	self.VITESSETAPIS_1 = 10;
	self.VITESSETAPIS_2 = 20;
	self.VITESSETAPIS_3 = 30;
	self.VITESSETAPIS_4 = 40;
	self.VITESSETAPIS_5 = 50;
	self.VITESSETAPIS_6 = 60;
	self.VITESSETAPIS_7 = 70;
	self.VITESSETAPIS_8 = 80;
	self.VITESSETAPIS_9 = 90;
	self.VITESSETAPIS_10 = 100;	

	self.VitesseTapisActuelle = self.VITESSETAPIS_5;

		-- Calcul de chaque vitesse --
	self.originalVitesseTapis = 0.00002
	self.VitessesTapis = {}
	self.VitessesTapis[1] = (self.originalVitesseTapis*0);
	self.VitessesTapis[2] = (self.originalVitesseTapis*0.1);
	self.VitessesTapis[3] = (self.originalVitesseTapis*0.2);
	self.VitessesTapis[4] = (self.originalVitesseTapis*0.3);
	self.VitessesTapis[5] = (self.originalVitesseTapis*0.4);
	self.VitessesTapis[6] = (self.originalVitesseTapis*0.5);
	self.VitessesTapis[7] = (self.originalVitesseTapis*0.6);
	self.VitessesTapis[8] = (self.originalVitesseTapis*0.7);
	self.VitessesTapis[9] = (self.originalVitesseTapis*0.8);
	self.VitessesTapis[10] = (self.originalVitesseTapis*0.9);
	self.VitessesTapis[11] = self.originalVitesseTapis;
	
		-- Calcul de chaque dbit --
	self.originalDebit = 250;
	self.Debit = {}
	self.Debit[1] = (self.originalDebit*0);
	self.Debit[2] = (self.originalDebit*0.1);
	self.Debit[3] = (self.originalDebit*0.2);
	self.Debit[4] = (self.originalDebit*0.3);
	self.Debit[5] = (self.originalDebit*0.4);
	self.Debit[6] = (self.originalDebit*0.5);
	self.Debit[7] = (self.originalDebit*0.6);
	self.Debit[8] = (self.originalDebit*0.7);
	self.Debit[9] = (self.originalDebit*0.8);
	self.Debit[10] = (self.originalDebit*0.9);
	self.Debit[11] = self.originalDebit;	

		-- Activation des CuttingAreas --
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, LaCampagne.getIsAreaActive);
	
		-- Mise en marche Prise de Force --
	self.setPDF = SpecializationUtil.callSpecializationsFunction("setPDF");	
	self.PDF = false;
	
		-- Animation des Herissons --
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;
	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;

		-- Coupure Tapis --
	self.setTapis = SpecializationUtil.callSpecializationsFunction("setTapis");
	self.Tapis = false;
	
		-- RPM --
	self.saveMinimumRpm = 0;
	
end;

function LaCampagne:delete()
end;

function LaCampagne:readStream(streamId, connection)
    self:setPorte(streamReadBool(streamId), true);
	local augmenterVitesseTapis = streamReadBool(streamId);
    self:setAugmenterVitesseTapis(augmenterVitesseTapis, true);
	local diminuerVitesseTapis = streamReadBool(streamId);
    self:setDiminuerVitesseTapis(diminuerVitesseTapis, true);
	self.VitesseTapisActuelle = streamReadInt16(streamId);
    self:setPDF(streamReadBool(streamId), true);
	self:setTapis(streamReadBool(streamId), true);
    self:setEchelle(streamReadBool(streamId), true);
end;

function LaCampagne:writeStream(streamId, connection)
	streamWriteBool(streamId, self.Porte);
	streamWriteBool(streamId, self.augmenterVitesseTapis);
	streamWriteBool(streamId, self.diminuerVitesseTapis);
	streamWriteInt16(streamId, self.VitesseTapisActuelle);
	streamWriteBool(streamId, self.PDF);
	streamWriteBool(streamId, self.Tapis);
	streamWriteBool(streamId, self.Echelle);
end;

function LaCampagne:readUpdateStream(streamId, timestamp, connection)
end;

function LaCampagne:writeUpdateStream(streamId, connection, dirtyMask)
end;

function LaCampagne:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LaCampagne:keyEvent(unicode, sym, modifier, isDown)
end;

function LaCampagne:update(dt)																
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.PORTE) then
			self:setPorte(not self.Porte);
		end;
		if InputBinding.hasEvent(InputBinding.AUGMENTER_VITESSETAPIS) then
			if self.VitesseTapisActuelle < self.VITESSETAPIS_10 then
				self:setAugmenterVitesseTapis(not self.augmenterVitesseTapis);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.DIMINUER_VITESSETAPIS) then
			if self.VitesseTapisActuelle > self.VITESSETAPIS_0 then
				self:setDiminuerVitesseTapis(not self.diminuerVitesseTapis);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setPDF(not self.PDF);
		end;
		if InputBinding.hasEvent(InputBinding.TAPIS) then
			self:setTapis(not self.Tapis);
		end;
	end;
	if self.descendu then
		if InputBinding.hasEvent(InputBinding.ECHELLE) then
			self:setEchelle(not self.Echelle);
		end;
		if InputBinding.hasEvent(InputBinding.FILET) then
			self:setFilet1(not self.Filet1);			
		end;
		if self.Echelle then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Plier_Echelle"), self.typeDesc), InputBinding.ECHELLE);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Deplier_Echelle"), self.typeDesc), InputBinding.ECHELLE);
		end;
		if self.Filet1 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Enlever_Filet"), self.typeDesc), InputBinding.FILET);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Mettre_Filet"), self.typeDesc), InputBinding.FILET);
		end;
	end;
end;

function LaCampagne:updateTick(dt)
    if self:getIsActive() then 
		if self.PDF then
			if self.Tapis then
				self.hayBase.offset = self.hayBase.offset + self.hayBase.speed*dt;
				setShaderParameter(self.hayBase.node, "movingDirection", 0,self.hayBase.offset,0,0,false);	-- Mouvement Tapis --
				if self.Porte then
					if self.fillLevel > 14250 then		-- amorcage --										
						if self.VitesseTapisActuelle == self.VITESSETAPIS_0 then				
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0;			-- Dbit en fonction de la vitesse du tapis choisie et du remplissage de l'pandeur --
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_1 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.1;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_2 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.2;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_3 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.3;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_4 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.4;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_5 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.5;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_6 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.6;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_7 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.7;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_8 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.8;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_9 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage*0.9;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_10 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitamorcage;
						else
							print("Pas de vitesse de tapis !");
						end;
					elseif self.fillLevel > 3750 and self.fillLevel < 14250 then     -- palier --
						if self.VitesseTapisActuelle == self.VITESSETAPIS_0 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[1];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_1 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[2];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_2 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[3];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_3 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[4];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_4 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[5];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_5 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[6];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_6 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[7];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_7 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[8];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_8 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[9];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_9 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[10];
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_10 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debit[11];
						else
							print("Pas de vitesse de tapis !");
						end;
					elseif self.fillLevel < 3750 then			-- decroissance de debit
						if self.VitesseTapisActuelle == self.VITESSETAPIS_0 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_1 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.1;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_2 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.2;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_3 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.3;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_4 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.4;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_5 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.5;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_6 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.6;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_7 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.7;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_8 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.8;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_9 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance*0.9;
						elseif self.VitesseTapisActuelle == self.VITESSETAPIS_10 then
							self.sprayLitersPerSecond[self.currentFillType] = self.Debitdecroissance;
						else
							print("Pas de vitesse de tapis !");
						end;
					end;
				end;
			else
				self.sprayLitersPerSecond[self.currentFillType] = 0			-- Pas de dbit si porte PDF non enclenche, si porte ferme et si tapis coup --
			end;
            if self.sprayLitersPerSecond[self.currentFillType] > 5 and self.fillLevel > 0 then	-- Activation ou non des particules en fonction du tapis --					
                for k,sprayValve in pairs(self.sprayValves) do
                    Utils.setEmittingState(sprayValve.particleSystems, true);
                end;
			else
                for k,sprayValve in pairs(self.sprayValves) do
                    Utils.setEmittingState(sprayValve.particleSystems, false);
                end;
			end;
			if self.sprayLitersPerSecond[self.currentFillType] > 200 then				-- Chute de rgime si trop de dbit --
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*0.5), -1200);				
			end;
            if not self.animationEnabled then								-- Animation des Herissons --
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
		end;
	end;
	if self.VitesseTapisActuelle == self.VITESSETAPIS_0 then		-- Vitesse Tapis --
		self.hayBase.speed = self.VitessesTapis[1];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_1 then
		self.hayBase.speed = self.VitessesTapis[2];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_2 then
		self.hayBase.speed = self.VitessesTapis[3];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_3 then
		self.hayBase.speed = self.VitessesTapis[4];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_4 then
		self.hayBase.speed = self.VitessesTapis[5];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_5 then
		self.hayBase.speed = self.VitessesTapis[6];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_6 then
		self.hayBase.speed = self.VitessesTapis[7];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_7 then
		self.hayBase.speed = self.VitessesTapis[8];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_8 then
		self.hayBase.speed = self.VitessesTapis[9];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_9 then
		self.hayBase.speed = self.VitessesTapis[10];
	elseif self.VitesseTapisActuelle == self.VITESSETAPIS_10 then
		self.hayBase.speed = self.VitessesTapis[11];
	else
		print("Pas de vitesse de tapis !");
	end;
	self.Debitamorcage = (-0.091*self.fillLevel + 1545);		-- calcul amorcage --
	self.Debitdecroissance = (0.067*self.fillLevel + 20);		-- calcul decroissance
	
	if self.attacherVehicle ~= nil and self.saveMinimumRpm ~= 0 and self.attacherVehicle.motor ~= nil then		-- RPM UP EDIT --
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000012*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
		if self.PDF then
			self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*0.5), -2200);
		else
			self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*3), self.saveMinimumRpm);
		end;		
	end;
	
	if self.Filet1 then
		setVisibility(self.Filet, true);
	else
		setVisibility(self.Filet, false);		
	end;

	if self.attacherVehicle and g_currentMission.player ~= nil then
		local nearestDistance = 2.0;
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.descendu = true;
		else
			self.descendu = false;
		end;
	end;
	
end;
  
function LaCampagne:draw()
    if self.isClient then
		if self.VitesseTapisActuelle ~= nil then
			local diminuer = InputBinding.getKeyNamesOfDigitalAction(InputBinding.DIMINUER_VITESSETAPIS);
			local augmenter = InputBinding.getKeyNamesOfDigitalAction(InputBinding.AUGMENTER_VITESSETAPIS);
			g_currentMission:addExtraPrintText(string.format(g_i18n:getText("VITESSETAPIS_ACTUELLE"), self.VitesseTapisActuelle, diminuer, augmenter));		-- Affichage du pourcentage de la vitesse du Tapis --
		end;
    end;
	if self.Porte then 
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("LEVER_PORTE"), self.typeDesc), InputBinding.PORTE);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BAISSER_PORTE"), self.typeDesc), InputBinding.PORTE);
	end;
	if self.PDF then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Desenclencher_PDF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Enclencher_PDF"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	end;
	if self.Tapis then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Couper_Tapis"), self.typeDesc), InputBinding.TAPIS);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Allumer_Tapis"), self.typeDesc), InputBinding.TAPIS);
	end;
	if self.sprayLitersPerSecond[self.currentFillType] ~= nil then
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("DEBIT"), self.sprayLitersPerSecond[self.currentFillType]));		-- Affichage du dbit --
	end;
end;

function LaCampagne:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.PDF = false;
end;

function LaCampagne:onLeave()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.PDF = false;
end;

function LaCampagne:onDetach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.PDF = false;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy1 == steerable then
			steerable.motor.minRpm = self.saveMinimumRpm;
			self.attacherVehicleCopy1 = nil;
		end;
	end;
end;

function LaCampagne:onAttach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.PDF = false;
end;

function LaCampagne:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy1 == nil then
		self.attacherVehicleCopy1 = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.saveMinimumRpm = self.attacherVehicle.motor.minRpm;
	else
		if self.attacherVehicle.saveMinimumRpm ~= nil then
			self.saveMinimumRpm = self.attacherVehicle.saveMinimumRpm;
		else
			self.attacherVehicle.saveMinimumRpm  = 100;
		end;
	end;
end;

function LaCampagne:setAugmenterVitesseTapis(augmenterVitesseTapis, noEventSend)
	SetAugmenterVitesseTapisEvent.sendEvent(self, augmenterVitesseTapis, noEventSend);
	self.augmenterVitesseTapis = augmenterVitesseTapis;

	if self.augmenterVitesseTapis == true then
		self.VitesseTapisActuelle = self.VitesseTapisActuelle+10;
		self.augmenterVitesseTapis = false;
	end;
end;

function LaCampagne:setDiminuerVitesseTapis(diminuerVitesseTapis, noEventSend)
	SetDiminuerVitesseTapisEvent.sendEvent(self, diminuerVitesseTapis, noEventSend);
	self.diminuerVitesseTapis = diminuerVitesseTapis;

	if self.diminuerVitesseTapis == true then
		self.VitesseTapisActuelle = self.VitesseTapisActuelle-10;
		self.diminuerVitesseTapis = false;
	end;
end;

function LaCampagne:setPorte(Porte,noEventSend)
	SetPorteEvent.sendEvent(self, Porte, noEventSend);
	if not Porte then
		if self.PorteAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PorteAnimation, -1, nil, true);
			self.Porte = false;
		end;
	else
		if self.PorteAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PorteAnimation, 1, nil, true);
			self.Porte = true;
		end;
	end;
end;

function LaCampagne:setPDF(PDF, noEventSend)
   SetPDFEvent.sendEvent(self, PDF, noEventSend)
   self.PDF = PDF;
end;

function LaCampagne:setTapis(Tapis, noEventSend)
   SetTapisEvent.sendEvent(self, Tapis, noEventSend)
   self.Tapis = Tapis;
end;

function LaCampagne:setEchelle(Echelle,noEventSend)
	SetEchelleEvent.sendEvent(self, Echelle, noEventSend);
	if not Echelle then
		if self.EchelleAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.EchelleAnimation, -1, nil, true);
			self.Echelle = false;
		end;
	else
		if self.EchelleAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.EchelleAnimation, 1, nil, true);
			self.Echelle = true;
		end;
	end;
end;

function LaCampagne:setFilet1(Filet1, noEventSend)
   self.Filet1 = Filet1;
end;

function LaCampagne:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
		return superFunc(self, area) and self.PDF and self.Tapis and self.sprayLitersPerSecond[self.currentFillType] > 0;
    end;
	return self.PDF;	
end;