chepi = {};

function chepi.prerequisitesPresent(specializations)
    return true;
end;

function chepi:load(xmlFile)
	
	self.shaderParts = {};
	local i=0;
	while true do
		local partName = string.format("vehicle.shaderParts.shaderPart(%d)", i);
		local part = {};
		local nodeString = getXMLString(xmlFile, partName .. "#index");
		if nodeString == nil then
			break;
		else
			part.index = Utils.indexToObject(self.components, nodeString);
			part.offSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#offSpeed"), 90000000000);
			part.onSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#onSpeed"), 1.0);
			setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
			local isVisibility = getXMLString(xmlFile, partName .. "#setVisibilityTurnOn");
			if isVisibility ~= "" and isVisibility == "true" then
				part.visibility = false;
				setVisibility(part.index, part.visibility);
			end;
			table.insert(self.shaderParts, part);
		end;
		i = i+1;
	end;
	
end;

function chepi:delete()
end;

function chepi:readStream(streamId, connection)
end;

function chepi:writeStream(streamId, connection)
end;

function chepi:mouseEvent(posX, posY, isDown, isUp, button)
end;

function chepi:keyEvent(unicode, sym, modifier, isDown)
end;

function chepi:update(dt)
end;

function chepi:updateTick(dt)
	if self.isTurnedOn or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		self:setAnimationTime(2, 1);
		self:setAnimationTime(3, self.animationParts[3].animDuration);
		for k, part in pairs(self.shaderParts) do
			setShaderParameter(part.index, "partScale", part.onSpeed, 1, 0, 0, false);
		end;
		if self.animationParts[3].clipEndTime then
			for k, part in pairs(self.shaderParts) do
				if part.visibility ~= nil then
					part.visibility = true;
					setVisibility(part.index, part.visibility);
				end;
			end;
		end;
	else
		self:setAnimationTime(3, self.animationParts[3].offSet);
		if self.animationParts[3].clipStartTime then
			for k, part in pairs(self.shaderParts) do
				setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
				if part.visibility ~= nil then
					part.visibility = false;
					setVisibility(part.index, part.visibility);
				end;
			end;
			self:setAnimationTime(2, 0);
		end;
	end;	
end;

function chepi:getIsAreaActive(superFunc, area)
	local isActive = false;
	if (self.isTurnedOn and self.animationParts[3].clipEndTime) or (not self.isTurnedOn and self.animationParts[3].clipStartTime) then
		isActive = true;
	end;
    if superFunc ~= nil then
        return superFunc(self, area) and isActive;
    end;
	return isActive;	
end;

function chepi:draw()
end;

function chepi:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self:setAnimationTime(1, self.animationParts[1].animDuration);
end;

function chepi:onDetach()
	self:setAnimationTime(1, self.animationParts[1].startPosition);
end;

function chepi:aiTurnOn()
	self:setIsTurnedOn(true);
end;

function chepi:aiTurnOff()
	self:setIsTurnedOn(false);
end;

function chepi:aiLower()
	self:setIsTurnedOn(true);
end;

function chepi:aiRaise()
	self:setIsTurnedOn(false);
end;