--
-- AlternativeTippingTrailer
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		01/08/11
-- @version:	v1.1
-- @history:	v1.0 - initial implementation
-- 				v1.1 - FS13 Conversion - Xentro (Marcus@Xentro.se)
--
--

AlternativeTippingTrailer = {};

function AlternativeTippingTrailer:update(dt)
	if g_currentMission.alternativeTipTrigger ~= nil then
		local tipIndex = Utils.getNoNil(self.toggleTipSideIndex, g_currentMission.alternativeTipTrigger.referenceTipIndex); -- ToggleTipSide compatible
		
		if self.tipReferencePoints[tipIndex] ~= nil then
			--*****************************  DURAL *******************************************
			--** parenthesis for better lisibility and reliability
			--if self.triggerPlacement == nil or self.triggerPlacement ~= nil and self.triggerPlacement ~= self.tipReferencePoints[tipIndex].node then
			if self.triggerPlacement == nil or (self.triggerPlacement ~= nil and self.triggerPlacement ~= self.tipReferencePoints[tipIndex].node) then
				self.triggerPlacement = self.tipReferencePoints[tipIndex].node;
			end;
		end;
		
		if self:getIsActive() and self.triggerPlacement ~= nil then
			local notAllowedSpec = SpecializationUtil.hasSpecialization(StrawBlower, self.specializations) or SpecializationUtil.hasSpecialization(MixerWagon, self.specializations);
			
			if not notAllowedSpec then
				self.isInActiveTipRange = g_currentMission.trailerInTipRange == self;
				
				if self:getIsActiveForInput(true) then
--*****************************  DURAL *******************************************
--** less precise regarding "speed"
					--if self.movingDirection == 0 and not self.isInActiveTipRange and self.fillLevel > 0 and self.tipState == Trailer.TIPSTATE_CLOSED then
					if math.abs(self.lastSpeedReal)<0.0002 and not self.isInActiveTipRange and self.fillLevel > 0 and self.tipState == Trailer.TIPSTATE_CLOSED then
						if g_currentMission.alternativeTipTrigger:getTriggerByFilltype(Fillable.fillTypeIntToName[self.currentFillType]) ~= nil then
							if not g_currentMission.alternativeTipTrigger:isTrailerFruitAllowed(self.currentFillType) then
								if Input.isKeyPressed(Input.KEY_lctrl) then
									self.printTriggerError2 = self.time + 500;
								end;
							end;
							
							if InputBinding.hasEvent(InputBinding.ALTERNATIVETIPPING_START_TIPPING) then
								local allowed = true;
								for _, trigger in pairs(g_currentMission.tipTriggers) do
									if trigger.isExtendedTrigger and trigger.currentFillType ~= self.currentFillType then
										local x1, y1, z1 = getWorldTranslation(self.triggerPlacement);
										local x2, y2, z2 = getWorldTranslation(trigger.triggerId);
										--************************************  DURAL *************************************
										--do not compute y distance because triggerPlacement can be relatively high compare to ground level (especially for combines)
										--local distance = Utils.vector3Length(x2-x1, y2-y1, z2-z1);
										local distance = Utils.vector2Length(x2-x1, z2-z1);
										if distance < g_currentMission.alternativeTipTrigger.minDistanceTriggers then
											allowed = false;
											self.printTriggerError = self.time + 3500;
											--************************************  DURAL *************************************
											--no need to continue here ...
											break;
										end;
									end;
								end;
								
								if allowed then
									g_currentMission.alternativeTipTrigger:addNewTrigger(self, false, AlternativeTipTrigger.TRAILER, tipIndex, false);
								end;
							end;
						end;
					end;
				end;
			else
				self.isInActiveTipRange = true;
			end;
		end;
	end;
end;
Trailer.update = Utils.appendedFunction(Trailer.update, AlternativeTippingTrailer.update);

function AlternativeTippingTrailer:draw()

	--*****************************  DURAL *******************************************
	--** less precise regarding "speed"
	--if self.movingDirection == 0 and g_currentMission.alternativeTipTrigger ~= nil then
	if math.abs(self.lastSpeedReal)<0.0002 and g_currentMission.alternativeTipTrigger ~= nil then
		if self:getIsActiveForInput(true) then			
			if self.isInActiveTipRange ~= nil and not self.isInActiveTipRange and self.fillLevel > 0 and self.tipState == Trailer.TIPSTATE_CLOSED then				
				if g_currentMission.alternativeTipTrigger:isTrailerFruitAllowed(self.currentFillType) then					
					if g_currentMission.alternativeTipTrigger:getTriggerByFilltype(Fillable.fillTypeIntToName[self.currentFillType]) ~= nil then
						g_currentMission:addHelpButtonText(g_i18n:getText("ALTERNATIVETIPPING_START_TIPPING"), InputBinding.ALTERNATIVETIPPING_START_TIPPING);
					end;
				end;
			end;
			
			if self.printTriggerError ~= nil then
				if self.time < self.printTriggerError then
					g_currentMission:addWarning(g_i18n:getText("ALTERNATIVETIPPING_TIPPING_NOT_ALLOWED"), 0.018, 0.033);
				end;
			end;
			
			if self.fillLevel > 0 then
				if self.printTriggerError2 ~= nil and self.time < self.printTriggerError2 then
--********************************************* DURAL **************************************************************************
-- display correct bound keys instead of "Q" : many players do not play with "qwerty" keyboards				
					g_currentMission:addWarning(g_i18n:getText("ALTERNATIVETIPPING_TIPPING_WARNING") .. " \n\n" .. string.format(g_i18n:getText("ALTERNATIVETIPPING_TIPPING_WARNING_DESC"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ALTERNATIVETIPPING_START_TIPPING)), 0.018, 0.033);
				end;
			end;
		end;
	end;
end;
Trailer.draw = Utils.appendedFunction(Trailer.draw, AlternativeTippingTrailer.draw);