--
-- handbrake Specialization by -UNKNOWN-
-- reedited by Blacky_BPG
--

parkingBrake = {};
parkingBrake.modDir = g_currentModDirectory;

function parkingBrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function parkingBrake:load(xmlFile)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	if g_newGUISkin then
		self.parkingBrakeOnHud = Overlay:new("hBOn", (parkingBrake.modDir.."huds/brake_on_ngs.dds"), 0.78, 0.134, 0.0288, 0.035);
		self.parkingBrakeOffHud = Overlay:new("hBOff", (parkingBrake.modDir.."huds/brake_off_ngs.dds"), 0.78, 0.134, 0.0288, 0.035);
	else
		self.parkingBrakeOnHud = Overlay:new("hBOn", (parkingBrake.modDir.."huds/brake_on.dds"), 0.9443, 0.172, 0.0288, 0.039);
		self.parkingBrakeOffHud = Overlay:new("hBOff", (parkingBrake.modDir.."huds/brake_off.dds"), 0.9443, 0.172, 0.0288, 0.039);
	end;
	self.setparkingBrakeState = SpecializationUtil.callSpecializationsFunction("setparkingBrakeState");

	self.parkingBrake = true;

	self.parkingBrakelight = nil;
	local hblight = getXMLString(xmlFile, "vehicle.handbrakelight#index");
	if hblight ~= nil then
		self.parkingBrakelight = Utils.indexToObject(self.rootNode, hblight);
	end;

	parkingBrakeSoundFile = Utils.getFilename("Sounds/handbrake_on.ogg", self.baseDirectory);
	self.parkingBrakeSoundId = createSample("parkingBrakeSound");
	loadSample(self.parkingBrakeSoundId, parkingBrakeSoundFile, false);
	self.parkingBrakePlaying = false;

	self.parkingBrakeReleasePlaying = false;
	brakereleaseSoundFile = Utils.getFilename("Sounds/handbrake_release.ogg", self.baseDirectory);
	self.parkingBrakeReleaseSoundId = createSample("brakereleaseSound");
	loadSample(self.parkingBrakeReleaseSoundId, brakereleaseSoundFile, false);

	self.parkingBrakeReleasePlaying = false;
	self.BreakForceVal = 10000/self.motor.brakeForce;
	if g_currentMission.extraHudMode == nil then
		g_currentMission.extraHudMode = 0;
	end;

    self.parkingBrakeTurnOff = false;
end;

function parkingBrake:delete()

end;

function parkingBrake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function parkingBrake:keyEvent(unicode, sym, modifier, isDown)
end;

function parkingBrake:readStream(streamId, connection)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	self:setparkingBrakeState(streamReadBool(streamId));
end;

function parkingBrake:writeStream(streamId, connection)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	streamWriteBool(streamId, self.parkingBrake);
end;

function parkingBrake:updateTick(dt)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	if self.isServer then
		if self.parkingBrake then
			for k,wheel in pairs(self.wheels) do
				wheel.hasHandbrake = true;
				if self.isRealistic then
					WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, true, 0, true)
				else
					WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, true, 0)
				end;
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, wheel.steeringAngle);
			end;
		elseif (not self.parkingBrake) and self.parkingBrakeTurnOff then
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, wheel.steeringAngle);
			end;
			self.parkingBrakeTurnOff = false;
		end;
	end;
end;

function parkingBrake:update(dt)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	if self.isClient then
		if self:getIsActiveForInput() or self:getIsActiveForInput(false) then
			if InputBinding.hasEvent(InputBinding.handbrake) then
				self:setparkingBrakeState(not self.parkingBrake);
				if self.parkingBrake and self:getIsActiveForSound() and self.isClient then
					playSample(self.parkingBrakeSoundId,1,1,0);
				else
					playSample(self.parkingBrakeReleaseSoundId,1,1,0);
				end;
			end;
		end;
		local ax = false;
		if self.axisForward ~= nil then
			if self.axisForward ~= 0 then
				if self.axisForward < -0.2 then
					ax = true;
				end;
			end;
		end;
		if Input.isKeyPressed(Input.KEY_s) or ax == true then
			if not self.braking then
				self.braking = true;
			end;
			if not self.parkingBrakePlaying and self:getIsActiveForSound() then
				self.parkingBrakePlaying = true;
			end;
			self.parkingBrakeReleasePlaying = false;
		else
			self.parkingBrakePlaying = false;
			self.braking = false;
			if not self.parkingBrakeReleasePlaying and self:getIsActiveForSound() then
				self.parkingBrakeReleasePlaying = true;
			end;
		end;
	end;
end;

function parkingBrake:draw()
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	if self.isEntered then
		if self.parkingBrake then
			g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeOFF"), InputBinding.handbrake);
			self.parkingBrakeOnHud:render();
			if self.isMotorStarted then
				local ax = false;
				if self.axisForward ~= nil then
					if self.axisForward < -0.4 then
						ax = true;
					end;
				end;
				if Input.isKeyPressed(Input.KEY_w) or ax == true then
					g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
				end;
			end;
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeON"), InputBinding.handbrake);
			self.parkingBrakeOffHud:render();
		end;
	end;
end;

function parkingBrake:onLeave()

end;

function parkingBrake:setparkingBrakeState(state, noEventSend)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	parkingBrakeEvent.sendEvent(self, state, noEventSend);
	self.parkingBrake = state;
	if state then
		self.parkingBrakeTurnOff = state;
	end;
	if self.parkingBrakelight ~= nil then
		setVisibility(self.parkingBrakelight, state);
	end;
end;

-----------------------------------------------------

parkingBrakeEvent = {};
parkingBrakeEvent_mt = Class(parkingBrakeEvent, Event);

InitEventClass(parkingBrakeEvent, "parkingBrakeEvent");

function parkingBrakeEvent:emptyNew()
    local self = Event:new(parkingBrakeEvent_mt);
    self.className="parkingBrakeEvent";
    return self;
end;

function parkingBrakeEvent:new(vehicle, parkingBrake)
    local self = parkingBrakeEvent:emptyNew()
    self.vehicle = vehicle;
	self.parkingBrake = parkingBrake;
    return self;
end;

function parkingBrakeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.parkingBrake = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function parkingBrakeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.parkingBrake);
end;

function parkingBrakeEvent:run(connection)
	if self.vehicle ~= nil then
		if not connection:getIsServer() then
			g_server:broadcastEvent(parkingBrakeEvent:new(self.vehicle, self.parkingBrake), nil, connection, self.vehicle);
		end;
		if self.vehicle.setparkingBrakeState ~= nil then
			self.vehicle:setparkingBrakeState(self.parkingBrake, true);
		end;
	end;
end;
function parkingBrakeEvent.sendEvent(vehicle, parkingBrake, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(parkingBrakeEvent:new(vehicle, parkingBrake), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(parkingBrakeEvent:new(vehicle, parkingBrake));
		end;
	end;
end;

