--
-- playerInRangeTool
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.6
-- @date:       2013-06-26
-- 
--
playerInRangeTool = {};
addModEventListener(playerInRangeTool);

function playerInRangeTool:loadMap(name)
	self.updateTime = 0;
	self.playerMinDistance = 4.5;
	self.scriptVersion = 1.0;
	
	if g_currentMission.playerInRangeTool == nil then
		g_currentMission.playerInRangeTool = self;
	else
		if g_currentMission.playerInRangeTool.scriptVersion < self.scriptVersion then
			if g_currentMission.playerInRangeTool ~= self then
				g_currentMission.playerInRangeTool = self;
				print("Info: playerInRangeTool was replaced with a newer version.");
			end;
		end;
	end;
end;

function playerInRangeTool:deleteMap()
	g_currentMission.playerInRangeTool = nil;
end;

function playerInRangeTool:mouseEvent(posX, posY, isDown, isUp, button)
end;

function playerInRangeTool:keyEvent(unicode, sym, modifier, isDown)
end;

function playerInRangeTool:update(dt)
	if g_currentMission.playerInRangeTool ~= nil and g_currentMission.playerInRangeTool == self then
		if g_currentMission.player ~= nil then
			local tableEmpty = true;
			
			if g_currentMission.player.isControlled and g_currentMission.player.isEntered then
				if g_currentMission.player.activeTool == nil then
					local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
					
					for i, vehicle in pairs(g_currentMission.vehicles) do
						local x, y, z = getWorldTranslation(vehicle.components[1].node);
						local distance = Utils.vector3Length(x - px, y - py, z - pz);
						local update = false;
						
						if distance < self.playerMinDistance then
							if g_currentMission.player.closestTool == nil then
								update = true;
							else
								if g_currentMission.player.closestToolDistance > distance then
									update = true;
								end;
								if g_currentMission.player.closestTool == vehicle then
									update = true;
								end;
							end;
							
							if update then
								g_currentMission.player.closestTool = vehicle;
								g_currentMission.player.closestToolDistance = distance;
							end;
							
							tableEmpty = false;
						end;
					end;
				end;
			end;
			
			if tableEmpty then
				if g_currentMission.player.closestTool ~= nil then
					g_currentMission.player.closestTool = nil;
					g_currentMission.player.closestToolDistance = nil;
				end;
			end;
		end;
	end;
end;

function playerInRangeTool:draw()
end;