--
-- manualFillFuel
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-06-27
-- 
--[[
	collision mask on fuel trailers will limit the refill of trailers > trailers
]]--

manualFillFuel = {};
manualFillFuel.baseDirectory = g_currentModDirectory;

addModEventListener(manualFillFuel);

function manualFillFuel:loadMap(name)
	self.scriptVersion = 1.0;
	
	if g_currentMission.manualFillFuel == nil or g_currentMission.manualFillFuel ~= nil and g_currentMission.manualFillFuel.scriptVersion < self.scriptVersion then
		GasStation.triggerCallback = Utils.overwrittenFunction(GasStation.triggerCallback, manualFillFuel.triggerCallback);
		
		local x = 0.95;
		local y = 0.054;
		local width = 0.040625;
		local height = 0.14;
		
		self.barHeight = 0.09;
		
		self.fuelOverlay = {};
		self.fuelOverlay["background"] = {};
		self.fuelOverlay["background"] = Overlay:new("background", Utils.getFilename("backgroundBarrel.dds", manualFillFuel.baseDirectory .. "Hud/"), x, y, width, height);
		
		self.fuelOverlay["frame"] = {};
		self.fuelOverlay["frame"] = Overlay:new("frame", Utils.getFilename("frameBarrel.dds", manualFillFuel.baseDirectory .. "Hud/"), x, y, width, height);
		
		self.fuelOverlay["bar"] = {};
		self.fuelOverlay["bar"] = Overlay:new("bar", Utils.getFilename("barBarrel.dds", manualFillFuel.baseDirectory .. "Hud/"), x, y + 0.011, width, self.barHeight);
		
		g_currentMission.manualFillFuel = self;
		g_currentMission.manualFuelDistance = 3;
	end;
end;

function manualFillFuel:deleteMap()
	if self.fuelOverlay ~= nil then
		for _, hud in pairs(self.fuelOverlay) do
			hud:delete();
		end;
	end;
end;

function manualFillFuel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualFillFuel:keyEvent(unicode, sym, modifier, isDown)
end;

function manualFillFuel:update(dt)
	if g_currentMission.manualFillFuel == self then
		if g_currentMission.player ~= nil and g_currentMission.controlPlayer then
			local fillObject = g_currentMission.player.closestTool;
			
			if fillObject ~= nil then
				if fillObject.fuelFillTriggers ~= nil and table.getn(fillObject.fuelFillTriggers) ~= 0 then
					if g_gui.currentGui == nil and not g_currentMission.isPlayerFrozen then
						if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
							fillObject:setIsFuelFilling(not fillObject.isFuelFilling);
						end;
					end;
					
					local name = self.typeDesc;
					if name == "TypeDescription" or name == "nil" or name == nil then
						name = "";
					end;
					
					if fillObject.isFuelFilling then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("stop_refill_OBJECT"), name), InputBinding.ACTIVATE_OBJECT);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("refill_OBJECT"), name), InputBinding.ACTIVATE_OBJECT);
					end;
				end;
			end;
		end;
	end;
end;

function manualFillFuel:draw()
	if g_currentMission.manualFillFuel == self then
		if g_currentMission.player ~= nil and g_currentMission.controlPlayer then
			local fillObject = g_currentMission.player.closestTool;
			local activeTool = false;
			
			if fillObject == nil then
				local tool = g_currentMission.player.activeTool;
				
				if tool ~= nil then
					if tool.isFuelTanker ~= nil and tool.isFuelTanker then
						fillObject = tool;
						activeTool = true;
					end;
				end;
			end;
			
			if fillObject ~= nil then
				if fillObject.fuelFillTriggers ~= nil and table.getn(fillObject.fuelFillTriggers) ~= 0 and not activeTool or activeTool then
					local fuelLevel = fillObject.fuelFillLevel;
					if fuelLevel == nil and fillObject.getFillLevel ~= nil then
						fuelLevel = fillObject:getFillLevel(Fillable.FILLTYPE_FUEL);
					end;
					
					local capacity = fillObject.fuelCapacity;
					if capacity == nil then
						capacity = Utils.getNoNil(fillObject.capacity, 0);
					end;
					
					if capacity ~= 0 then
						if self.fuelOverlay["background"] ~= nil then
							self.fuelOverlay["background"]:render();
						end;
						
						local percentage = fuelLevel / capacity;
						
						if self.fuelOverlay["bar"] ~= nil then
							self.fuelOverlay["bar"].height = (self.barHeight * percentage);
							setOverlayUVs(self.fuelOverlay["bar"].overlayId, 0, 0, 0, math.min(1, percentage), 1, 0, 1, math.min(1, percentage));
							self.fuelOverlay["bar"]:render();
						end;
						
						setTextBold(true);
						setTextAlignment(RenderText.ALIGN_CENTER);
						
						setTextColor(0, 0, 0, 1);
						renderText(self.fuelOverlay["frame"].x + self.fuelOverlay["frame"].width / 2 - 0.001, self.fuelOverlay["frame"].y + 0.0835, 0.012, string.format("%2.0f%%" , percentage * 100));
						
						setTextColor(1, 1, 1, 1);
						renderText(self.fuelOverlay["frame"].x + self.fuelOverlay["frame"].width / 2 - 0.001, self.fuelOverlay["frame"].y + 0.085, 0.012, string.format("%2.0f%%" , percentage * 100));
						
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(false);
						
						if self.fuelOverlay["frame"] ~= nil then
							self.fuelOverlay["frame"]:render();
						end;
					end;
				end;
			end;
		end;
	end;
end;

-- fix for triggerCallback
function manualFillFuel:triggerCallback(superFunc, triggerId, otherId, onEnter, onLeave, onStay)
	if self.overrideManualFill == nil then
		if self.isEnabled and (onEnter or onLeave) then
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			if vehicle ~= nil and vehicle.addFuelFillTrigger ~= nil and vehicle.removeFuelFillTrigger ~= nil and vehicle ~= self then
				if (self.trailer ~= nil and vehicle ~= self.trailer) or self.trailer == nil then
					local count = Utils.getNoNil(self.vehiclesTriggerCount[vehicle], 0);
					
					if onEnter then
						self.vehiclesTriggerCount[vehicle] = count + 1;
						if count == 0 then
							vehicle:addFuelFillTrigger(self);
						end
					else
						self.vehiclesTriggerCount[vehicle] = count - 1;
						if count == 1 then
							self.vehiclesTriggerCount[vehicle] = nil;
							vehicle:removeFuelFillTrigger(self);
						end
					end;
				end;
			end;
		end;
	end;
end;