--
-- MilkFarm
--
-- @author  Mike LSNG
-- @date  16/12/13
--
-- Copyright (C) LS-NG Modteam, www.ls-nextgeneration.com

MilkFarm = {}

local MilkFarm_mt = Class(MilkFarm, Mission00);


function MilkFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MilkFarm_mt;
    end;
    local self = MilkFarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function MilkFarm:delete()
    MilkFarm:superClass().delete(self);
end;

function MilkFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/MilkFarm.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function MilkFarm:loadMap01Finished(node, arguments)

		self.terrainDetailAngleNumChannels = 8;
		
		self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("MilkFarm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;
	


    -- ATMs
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 156.58, 35.06, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Vehicle Shop
    --self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 198.0, 23.12, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 166.82, 44.03, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 299.07, -353.36, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -141.74, -4.28, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 468.45, -38.48, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- livestock
    --self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 393.58, -345.58, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Cows1", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 240.48, -286.03, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 176.00, 140.55, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 318.19, -426.64, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- egg sellpoints
    --self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -146.64, -13.86, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -145.69, -23.48, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 478.42, -56.82, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	
    -- spinnery
    --g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -146.46, 2.38, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    MilkFarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function MilkFarm:onStartMission()
    MilkFarm:superClass().onStartMission(self);
end;

function MilkFarm:mouseEvent(posX, posY, isDown, isUp, button)
    MilkFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MilkFarm:keyEvent(unicode, sym, modifier, isDown)
    MilkFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MilkFarm:update(dt)
    MilkFarm:superClass().update(self, dt);
end;

function MilkFarm:draw()
    MilkFarm:superClass().draw(self);
end;