BuyPlaceableHeapEvent = {}
BuyPlaceableHeapEvent_mt = Class(BuyPlaceableHeapEvent, BuyPlacableEvent)

function BuyPlaceableHeapEvent:emptyNew()
  local self = Event:new(BuyPlaceableHeapEvent_mt)
  return self
end

function BuyPlaceableHeapEvent:new(filename, x, y, z, rx, ry, rz)
  local self = BuyPlaceableHeapEvent:emptyNew()
  self.filename = filename
  self.x = x
  self.y = y
  self.z = z
  self.rx = rx
  self.ry = ry
  self.rz = rz
  return self
end

function BuyPlaceableHeapEvent:newServerToClient(successful)
  local self = BuyPlaceableHeapEvent:emptyNew()
  self.successful = successful
  return self
end

function BuyPlaceableHeapEvent:run(connection)
	if not connection:getIsServer() then
		local successful=false;
		local placeable=PlaceableHeap:new(g_currentMission:getIsServer(), g_currentMission:getIsClient())
		if placeable:load(self.filename, self.x, self.y, self.z, self.rx, self.ry, self.rz, false)then
			--print("loading PlaceableHeap successful")
			assert(g_currentMission:getIsServer())
			placeable:register()
			successful=true;
		else
			--print("loading PlaceableHeap unsuccessful")
			placeable:delete()
			placeable = nil
		end;
		connection:sendEvent(BuyPlaceableHeapEvent:newServerToClient(successful))
	end;
end

function BuyPlaceableHeapEvent:delete()
end;
