SetGridEvent = {};
SetGridEvent_mt = Class(SetGridEvent, Event);

InitEventClass(SetGridEvent, "SetGridEvent");

function SetGridEvent:emptyNew()
    local self = Event:new(SetGridEvent_mt);
    self.className="SetGridEvent";
    return self;
end;

function SetGridEvent:new(vehicle, gridState)
    local self = SetGridEvent:emptyNew()
    self.vehicle = vehicle;
	self.gridState = gridState;
    return self;
end;

function SetGridEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.gridState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetGridEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.gridState);
end;

function SetGridEvent:run(connection)   
	self.vehicle:toggleGrid(self.gridState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetGridEvent:new(self.vehicle, self.gridState), nil, connection, self.vehicle);
    end;
end;

function SetGridEvent.sendEvent(vehicle, gridState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetGridEvent:new(vehicle, gridState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetGridEvent:new(vehicle, gridState));
		end;
	end;
end;