--
-- Plane
-- Class for all Dolly Trailers
--
-- @author  Jack
-- @date  25/04/09
--
-- Copyright (C) Jack

Plane = {};

function Plane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Plane:load(xmlFile)
	

-- Plane
    self.plane = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.plane#index"));
-- PlaneA
    self.planeA = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.planeA#index"));
	self.planeActive = true;

	
  	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	

end;

function Plane:delete()   
end;


function Plane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plane:keyEvent(unicode, sym, modifier, isDown)

--Plane
	if isDown and sym == self.keys.PLANE1 then
		self.planeActive = not self.planeActive;
	end;
	
-- Plane (ende)

end;


function Plane:update(dt)

-- Plane1 (anfang)
		if self.planeActive then
				local plane = self.plane;
				setVisibility(plane);
				
				local planeA = self.planeA;
				setVisibility(planeA, false);

		else
				local plane = self.plane;
				setVisibility(plane, false);

				local planeA = self.planeA;
				setVisibility(planeA);

		end;	


-- Plane1 (ende)	

end;


function Plane:draw()
end;

function key_convert(key)
	if key < 256 then
		return string.upper(""..string.char(key).."");
	elseif key > 255 and key < 266 then
		return string.upper("KP"..string.char(key-208));
	else
		return "n/a";
	end;
end;

function Plane:allowFillType(fillType)
end;

function Plane:anim(varName, loopCheck)
end; 	

function Plane:delete()
end;

function Plane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plane:connectCollisions(varName)
end;

function Plane:draw()
	if self.planeActive then 
		g_currentMission:addExtraPrintText("Taste Z: Tent");
	else
		g_currentMission:addExtraPrintText("Taste Z: Tent");
	end;
end;


