--
-- Rundumleuchte
-- Specialization for beacon-lights
-- Spezialisierung fr Rundumleuchten
-- @author  Sven777b
-- 
-- Modifikationen erst nach Rcksprache
--

RUL1 = {};

function RUL1.prerequisitesPresent(specializations)
    return true;
end;

function RUL1:load(xmlFile)
		print("specialization rundumleuchten by Sven777b");
		local i = 0;
		self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
		while true do
			local rul = {};
			local objname = string.format("vehicle.rundumleuchten.rundumleuchte(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then 
      	break;
      end;
      rul1 = {};
      rul1.rotNode = Utils.indexToObject(self.components, rotnode);
      rul1.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(rul1.rotNode == nil or rul1.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      rul1.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      rul1.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (rul1.source == nil) then
	      	ru1l.emit = false;
	      else
      		rul1.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul1.emit then
      			setVisibility(rul1.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul1);
      end;
      i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);
end;

function RUL1:delete()
end;

function RUL1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RUL1:keyEvent(unicode, sym, modifier, isDown)
end;

function RUL1:update(dt)
	if self.rundumleuchtenAnz > 0 and self:getIsActive() then
    if InputBinding.hasEvent(InputBinding.Rul1) then
    	self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if self.rundumleuchtenAn then
      for i=1, self.rundumleuchtenAnz do
        rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
      end;
    end;
  end;
end;

function RUL1:draw()
	
end;

