
extraWeights = {};

function extraWeights.prerequisitesPresent(specializations)
    return true;
end;

function extraWeights:load(xmlFile)

	self.extraWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraWeights#count"), 0);
    self.weights = {};
    for i=1, self.extraWeights do
        local weightnamei = string.format("vehicle.extraWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 100);
end;

function extraWeights:delete()
end;

function extraWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function extraWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function extraWeights:update(dt)
	
		if self:getIsActive() then --aislarlo de otros objetos
	    self.singleWeight = (self.maxWeight / self.extraWeights);	
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if not Input.isKeyPressed(Input.KEY_KP_enter) then
				self.currentWeight = self.currentWeight + self.singleWeight;
				if self.currentWeight > self.maxWeight then
					self.currentWeight = 0;
				end;
			else
				self.currentWeight = self.currentWeight - self.singleWeight;
				if self.currentWeight < 0 then
					self.currentWeight = self.maxWeight;
				end;
			end;
		end;
		self.controlWeight = (self.currentWeight/self.singleWeight);
		if self.controlWeight > 0 then
			for i=1, self.controlWeight do
				setVisibility(self.weights[i], true);
				for j=i+1, self.extraWeights do
					setVisibility(self.weights[j], false);
				end;
			end;
		else
			for k=1, self.extraWeights do
				setVisibility(self.weights[k], false);
			end;
		end;
		if self.emptyMass == nil then
			self.emptyMass = getMass(self.components[1].node);
			self.currentMass = self.emptyMass;
		end;
		local newMass = self.emptyMass + (self.currentWeight/1000);
		if newMass ~= self.currentMass then
			setMass(self.components[1].node, newMass);
			self.currentMass = newMass;
			for k,v in pairs(self.components) do
				if v.node == self.components[1].node then
					if v.centerOfMass ~= nil then
						setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
					end;
					break;
				end;
			end;
		end;
	end;

end;

function extraWeights:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local currentWeight = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#currentWeight"), self.currentWeight);
		self.currentWeight = currentWeight;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function extraWeights:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentWeight="' .. tostring(self.currentWeight) ..'"';
	return attributes, nil;
end;


function extraWeights:onLeave()
end;

function extraWeights:draw()
if self.isMotorStarted then
g_currentMission:addHelpButtonText(string.format(g_i18n:getText("EXTRAWEIGHT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
end;
end;
