VarioHTW = {};

function VarioHTW.prerequisitesPresent(specializations)
	return true;
end;

function VarioHTW:load(xmlFile)
	self.rollsDis = {};
	self.rollsDis.object = {};
	self.rollsDis.speed = {};
	local i=1;
	while true do 
		local tmp = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.varioHTW#rollDis%d",i)));
		if tmp == nil then
			break;
		end;
		self.rollsDis.object[i] = tmp;
		self.rollsDis.speed[i] = 0;
		i=i+1;
	end;
	
	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#unloadingSpeed"), 0.001);
	self.hayBase.loadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#loadingSpeed"), 0.0005);
	self.hayBase.speed = self.hayBase.loadingSpeed;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);	
end;

function VarioHTW:delete()
end;

function VarioHTW:readStream(streamId, connection)

end;

function VarioHTW:writeStream(streamId, connection)

end;

function VarioHTW:mouseEvent(posX, posY, isDown, isUp, button)

end;

function VarioHTW:keyEvent(unicode, sym, modifier, isDown)

end;

function VarioHTW:update(dt)
	
end;

function VarioHTW:updateTick(dt)
	-- #### entladewalzen
	if	self.tipState == Trailer.TIPSTATE_OPEN or self.tipState == Trailer.TIPSTATE_OPENING then
		for i, j in pairs(self.rollsDis.object) do
			local rX, rY, rZ = getRotation(j);
			self.rollsDis.speed[i] = self.rollsDis.speed[i] + 0.005 + math.random()/200;
			self.rollsDis.speed[i] = math.min(self.rollsDis.speed[i], 0.4);
			if i==2 then
				rX = rX - self.rollsDis.speed[i];
			else
				rX = rX + self.rollsDis.speed[i];
			end;
			setRotation(j, rX, rY, rZ);
		end;
	end;
	if self.tipState == Trailer.TIPSTATE_CLOSING then
		for i, j in pairs(self.rollsDis.object) do
			local rX, rY, rZ = getRotation(j);
			self.rollsDis.speed[i] = self.rollsDis.speed[i] - 0.005 - math.random()/200;
			self.rollsDis.speed[i] = math.max(self.rollsDis.speed[i], 0.0);
			if i==2 then
				rX = rX + self.rollsDis.speed[i];
			else
				rX = rX - self.rollsDis.speed[i];
			end;
			setRotation(j, rX, rY, rZ);
		end;
	end;
end;

function VarioHTW:onAttach(attacherVehicle)

end;

function VarioHTW:onDetach()

end;

function VarioHTW:onStartTip(currentTipTrigger, noEventSend)
	setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
end;

function VarioHTW:onEndTip(noEventSend)
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;

function VarioHTW:draw()

end;
