-- 
-- Scrypt do przyczepy HL by Agromet Rdit: maciusboss1
-- Scrypt by maciusboss1
-- Data: 12.12.2011 r.
-- Zakaz przerabiania i brania do swoich modeli
-- Zapraszam na www.lsmodss.pl


maciusboss1 = {};

function maciusboss1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function maciusboss1:load(xmlFile)

	
	    self.plandeka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka#index"));
        self.plandekaActive = false;
        self.plandeka1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka1#index"));
        self.changeTools = SpecializationUtil.callSpecializationsFunction("changeTools");
		self.objectInRange = maciusboss1.objectInRange;


end;

function maciusboss1:readStream(streamId, connection)
	self:changeTools(streamReadBool(streamId), true);

end;

function maciusboss1:writeStream(streamId, connection)
	streamWriteBool(streamId, self.plandekaActive);
end;

function maciusboss1:delete()
end;

function maciusboss1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function maciusboss1:keyEvent(unicode, sym, modifier, isDown)
end;

function maciusboss1:update(dt)

	if self.plandeka ~= nil then
		setVisibility(self.plandeka, self.plandekaActive);
	end;
	if self.plandeka1 ~= nil then
		setVisibility(self.plandeka1, not self.plandekaActive);
	end;
	
	if self.isClient then
		if self:objectInRange(self.plandeka) then
			if InputBinding.hasEvent(InputBinding.maciusboss1_Plandeka) then
				self:changeTools(not self.plandekaActive);
			end;
			if self.plandekaActive then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("maciusboss1_ZDEJMIJ_PLANDEKE")), InputBinding.maciusboss1_Plandeka);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("maciusboss1_ZALOZ_PLANDEKE")), InputBinding.maciusboss1_Plandeka);
			end;
		end;
		

end;
end;

function maciusboss1:draw()
end;


function maciusboss1:onAttach()
	
end;

function maciusboss1:onDetach()
end;

function maciusboss1:onLeave()
end;

function maciusboss1:changeTools(plandekaStatus,noEventSend)
	ChangeToolsEvent.sendEvent(self, plandekaStatus, noEventSend);
	self.plandekaActive = plandekaStatus;
end;

function maciusboss1:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 4;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

