wheelextra = {};

function wheelextra.prerequisitesPresent(specializations)
    return true;
end;

function wheelextra:load(xmlFile)

	self.on = true;

	local numWheelAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheelAreas#count"), 0);
    self.wheelAreas = {}
    for i=1, numWheelAreas do
        self.wheelAreas[i] = {};
        local areanamei = string.format("vehicle.wheelAreas.wheelArea%d", i);
        self.wheelAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.wheelAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.5)
        self.wheelAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;
	self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;	
end;

function wheelextra:delete()
	for i=1, table.getn(self.wheelParticleSystems) do
		Utils.deleteParticleSystem(self.wheelParticleSystems[i].particleSystems);
    end;
end;

function wheelextra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelextra:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelextra:update(dt)

if self.on then
	for k, wheelArea in pairs(self.wheelAreas) do
        local x,y,z = getWorldTranslation(wheelArea.point);
        local w = wheelArea.width;
        local h = wheelArea.height;
		local x1 = x + h/2
		local x2 = x - h/2
		local z1 = z + w/2
		local z2 = z - w/2
		
		
		Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 8, x1, z2, x1, z1, x2, z2);
		Utils.cutFruitArea( 9, x1, z2, x1, z1, x2, z2);

	end;
end;
	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[2].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, self.wheels[i].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
		end;
	end;
end;

function wheelextra:draw()
end;

