 SetUnloadingEvent = {};
  SetUnloadingEvent_mt = Class(SetUnloadingEvent, Event);
  
  InitEventClass(SetUnloadingEvent, "SetUnloadingEvent");
  
  function SetUnloadingEvent:emptyNew()
     local self = Event:new(SetUnloadingEvent_mt);
      self.className="SetUnloadingEvent";
      return self;
  end;
  
  function SetUnloadingEvent:new(object, unloading)
      local self = SetUnloadingEvent:emptyNew()
      self.object = object;
      self.unloading = unloading;
      return self;
  end;
  
  function SetUnloadingEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.unloading = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function SetUnloadingEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.unloading);
  end;
  
  function SetUnloadingEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsUnloading(self.unloading, true);
  end;
  
  function SetUnloadingEvent.sendEvent(vehicle, unloading, noEventSend)
      if unloading ~= vehicle.isUnloading then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetUnloadingEvent:new(vehicle, unloading), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetUnloadingEvent:new(vehicle, unloading));
              end;
          end;
      end;
  end;