FertSetIsFillingEvent = {};
FertSetIsFillingEvent_mt = Class(FertSetIsFillingEvent, Event);
  
InitEventClass(FertSetIsFillingEvent, "FertSetIsFillingEvent");
  
function FertSetIsFillingEvent:emptyNew()
	local self = Event:new(FertSetIsFillingEvent_mt);
	self.className="FertSetIsFillingEvent";
	return self;
end;
  
function FertSetIsFillingEvent:new(object, isFilling)
	local self = FertSetIsFillingEvent:emptyNew()
	self.object = object;
	self.isFilling = isFilling;
	return self;
end;
 
function FertSetIsFillingEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.isFilling = streamReadBool(streamId);
	self:run(connection);
end;
  
function FertSetIsFillingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isFilling);
end;
  
function FertSetIsFillingEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	self.object:setIsSprayerFilling(self.isFilling, true);
end;
  
function FertSetIsFillingEvent.sendEvent(object, isFilling, noEventSend)
	if isFilling ~= object.isSowingMachineFilling then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(FertSetIsFillingEvent:new(object, isFilling), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(FertSetIsFillingEvent:new(object, isFilling));
			end;
		end;
	end;
end;