-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- written for Bautz LWL

PickupUpDown = {};

function PickupUpDown.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function PickupUpDown:load(xmlFile)
	self.pu = {};
	self.pu.jointNumber = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Pickup.Joint#jointNumber" ), nil);
	self.pu.upMaxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Pickup.Joint#upMaxSpeed" ), 1);

	self.pu.rotpartIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Pickup.Rotpart#index"));
	
	self.pickupIsDown = false;
	self.currentRot = 0;
end;

function PickupUpDown:delete()
end;
function PickupUpDown:readStream(streamId, connection)
end;
function PickupUpDown:writeStream(streamId, connection)
end;
function PickupUpDown:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PickupUpDown:keyEvent(unicode, sym, modifier, isDown)
end;

function PickupUpDown:update(dt)	
	if self:getIsActive() then
		if self.isTurnedOn == true then
		    rotate(self.pu.rotpartIndex, -0.01*dt , 0, 0 );
			self.pickupIsDown = true;
		else
			self.pickupIsDown = false;
		end;
		
		if self.pickupIsDown == true then
		    setJointRotationLimit(self.componentJoints[self.pu.jointNumber].jointIndex, 2, false, Utils.degToRad(-30), Utils.degToRad(30));
			self.currentRot = 30;
		end;
		if self.pickupIsDown == false then
		    if self.currentRot > 1 then
			    local speed = 0.3*self.pu.upMaxSpeed
				self.currentRot = self.currentRot - speed
				setJointRotationLimit(self.componentJoints[self.pu.jointNumber].jointIndex, 2, true, Utils.degToRad(-self.currentRot), Utils.degToRad(self.currentRot));			
			end;
		    
		end;
	end;
end;

function PickupUpDown:updateTick(dt)	
end;
function PickupUpDown:draw()
end;


