
PUV2 = {};

function PUV2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function PUV2:load(xmlFile)

	self.pu = {};
	self.pu.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Pickup#index"));	
	self.pu.upMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Pickup#upMaxRot" ), 0 );
	self.pu.downMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Pickup#downMaxRot" ), 0 );
	local rotmaxspeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Pickup#rotMaxSpeed" ), 1);
	self.pu.rotMaxSpeed = rotmaxspeed / 1000

	self.pu.rotpartIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Pickup.Rotpart#index"));
	local rotPartSpeed1 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Pickup.Rotpart#speed"));
	self.pu.rotpartSpeed = rotPartSpeed1 / 1000;
	
	self.pickupIsDown = false;
end;

function PUV2:delete()
end;
function PUV2:readStream(streamId, connection)
end;
function PUV2:writeStream(streamId, connection)
end;
function PUV2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PUV2:keyEvent(unicode, sym, modifier, isDown)
end;

function PUV2:update(dt)	
	if self:getIsActive() then
		if self.isTurnedOn == true then
		    rotate(self.pu.rotPartIndex, -dt*0.001, 0, 0 );
			self.pickupIsDown = true;
		else
			self.pickupIsDown = false;
		end;
		
		if self.pickupIsDown == true then
			local rotwx, dy, dz = getRotation(self.pu.index)
			if rotwx < self.pu.upMaxRot then
				rotate(self.pu.index, -dt*self.pu.rotMaxSpeed, 0, 0)
			end;
		end;
		if self.pickupIsDown == false then
			local rotwx, dy, dz = getRotation(self.pu.index)
			if rotwx > self.pu.downMaxRot then
				rotate(self.pu.index, dt*self.pu.rotMaxSpeed, 0, 0)
			end;	
		end;
	end;
end;

function PUV2:updateTick(dt)	
end;

function PUV2:draw()
end;


