SetSidewallLeftEvent = {};
SetSidewallLeftEvent_mt = Class(SetSidewallLeftEvent, Event);

InitEventClass(SetSidewallLeftEvent, "SetSidewallLeftEvent");

function SetSidewallLeftEvent:emptyNew()
    local self = Event:new(SetSidewallLeftEvent_mt);
    self.className="SetSidewallLeftEvent";
    return self;
end;

function SetSidewallLeftEvent:new(vehicle, state)
    local self = SetSidewallLeftEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetSidewallLeftEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetSidewallLeftEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetSidewallLeftEvent:run(connection)
	self.vehicle:setSidewallLeft(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSidewallLeftEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetSidewallLeftEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetSidewallLeftEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetSidewallLeftEvent:new(vehicle, state));
		end;
	end;
end;