SetDeichselRotEvent = {};
SetDeichselRotEvent_mt = Class(SetDeichselRotEvent, Event);

InitEventClass(SetDeichselRotEvent, "SetDeichselRotEvent");

function SetDeichselRotEvent:emptyNew()
    local self = Event:new(SetDeichselRotEvent_mt);
    self.className = "SetDeichselRotEvent";
    return self;
end;

function SetDeichselRotEvent:new(object, value)
    local self = SetDeichselRotEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function SetDeichselRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.value = streamReadFloat32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetDeichselRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.value);
end;

function SetDeichselRotEvent:run(connection)
	self.object:setDeichselRot(self.value, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDeichselRotEvent:new(self.object, self.value), nil, connection, self.object);
    end;	
end;

function SetDeichselRotEvent.sendEvent(vehicle, value, noEventSend)
	if value ~= vehicle.deichsel.angle then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetDeichselRotEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetDeichselRotEvent:new(vehicle, value));
			end;
		end;
	end;
end;

