--
-- Krampe
-- 
--
--
-- @author:		fruktor (wwww.modding-society.de)
-- @version:	v0.1
-- @date:		08/12/10
-- @history:	v0.1 - inital implementation
--
-- Copyright (C) 
--

Krampe = {};

function Krampe.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Krampe:load(xmlFile)

	self.setDeichselRot = SpecializationUtil.callSpecializationsFunction("setDeichselRot");

	local idx = getXMLInt(xmlFile, "vehicle.hubAnimation#animMoveIdx");
	local speed = getXMLFloat(xmlFile, "vehicle.hubAnimation#speed");
	self.muldeHubAnimIdx = idx;
	self.muldeHubAnimSpeed = speed;
	
	--<deichsel index="1" maxRot="4.5" minRot="-7" duration="3000"/>	
	self.deichsel = {};
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.deichsel#index"));
	local minRot = getXMLInt(xmlFile, "vehicle.deichsel#minRot");
	local maxRot = getXMLInt(xmlFile, "vehicle.deichsel#maxRot");
	local duration = getXMLInt(xmlFile, "vehicle.deichsel#duration");
	self.deichsel.node = node;
	self.deichsel.minRot = Utils.degToRad(minRot);
	self.deichsel.maxRot = Utils.degToRad(maxRot);
	self.deichsel.duration = duration;
	self.deichsel.angle = 0.0;
	self.updateAttacherJoint = false;
end;	
	
	

function Krampe:delete()
end;

function Krampe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Krampe:keyEvent(unicode, sym, modifier, isDown)
end;

function Krampe:update(dt)
	-- ### 
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.isPressed(InputBinding.MULDE_UP) then
				local delta = self.muldeHubAnimSpeed * (self.animationParts[self.muldeHubAnimIdx].offSet+dt);
				self:setAnimationTime(self.muldeHubAnimIdx, self.animationParts[self.muldeHubAnimIdx].currentPosition+delta, false);
			elseif InputBinding.isPressed(InputBinding.MULDE_DOWN) then
				local delta = self.muldeHubAnimSpeed * (self.animationParts[self.muldeHubAnimIdx].offSet+dt);
				self:setAnimationTime(self.muldeHubAnimIdx, self.animationParts[self.muldeHubAnimIdx].currentPosition-delta, false);
			end;
		end;
		--[[print("self.animationParts[self.muldeHubAnimIdx].currentPosition="..tostring(self.animationParts[self.muldeHubAnimIdx].currentPosition));
		if self.animationParts[self.muldeHubAnimIdx].currentPosition > 0 then --self.muldeHubAnimSpeed * (self.animationParts[self.muldeHubAnimIdx].offSet+dt) then 
			self.allowTipDischarge = false;
		else
			--self.allowTipDischarge = true;
		end;]]--
		if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) and self.animationParts[self.muldeHubAnimIdx].currentPosition > 0 then
			local delta = self.muldeHubAnimSpeed * (self.animationParts[self.muldeHubAnimIdx].offSet+dt);
			self:setAnimationTime(self.muldeHubAnimIdx, self.animationParts[self.muldeHubAnimIdx].currentPosition-delta, false);		
		end;

		if self:getIsActiveForInput() then
			if InputBinding.isPressed(InputBinding.DEICHSEL_UP) then
				local rx, ry, rz = getRotation(self.deichsel.node);
				local new = Utils.getMovedLimitedValues({rx}, {self.deichsel.minRot}, {self.deichsel.maxRot}, 1, self.deichsel.duration, dt, true);
				self:setDeichselRot(new[1]);
				--setRotation(self.deichsel.node, new[1], ry, rz);
				--self.updateAttacherJoint = true;
			elseif InputBinding.isPressed(InputBinding.DEICHSEL_DOWN) then
				local rx, ry, rz = getRotation(self.deichsel.node);
				local new = Utils.getMovedLimitedValues({rx}, {self.deichsel.minRot}, {self.deichsel.maxRot}, 1, self.deichsel.duration, dt, false);
				self:setDeichselRot(new[1]);
				--setRotation(self.deichsel.node, new[1], ry, rz);
				--self.updateAttacherJoint = true;
			end;
		end;		
	end;	

end;

function Krampe:updateTick(dt)

	
	-- ####
	if self.doJointSearchCylindered then
		if self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;
					self.doJointSearchCylindered = false;
					break;
				end;
			end;
		end;
		self.doJointSearchCylindered = false;
	end;
	
	-- #### update the attacherJoint!     
    if self.vehicleJoint ~= nil	and self.updateAttacherJoint == true then
		setRotation(self.deichsel.node, self.deichsel.angle, 0, 0);
        setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
		self.updateAttacherJoint = false;
	end;

end;

function Krampe:draw()
	if self:getIsActive() then
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("MULDE_UPDOWN"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MULDE_UP), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MULDE_DOWN)));
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("DEICHSEL_UPDOWN"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DEICHSEL_UP), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DEICHSEL_DOWN)));
	end;
end;

function Krampe:onAttach()
	self.doJointSearchCylindered = true;

end;

function Krampe:onDetach()
	self.vehicleJoint = nil;

	
	--[[local rX, rY, rZ = getRotation( Utils.indexToObject(self.components, "0|0") );
	
	if rX > Utils.degToRad(3) then
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILERLOW;
	else
		self.attacherJoint.jointType = Vehicle.JOINTTYPE_TRAILER;
	end;
	]]--
end;

function Krampe:onLeave()
end;

function Krampe:onDeactivate()
end;

function Krampe:onDeactivateSounds()
end;

function Krampe:setDeichselRot(value, noEventSend)
	SetDeichselRotEvent.sendEvent(self, value, noEventSend);
	self.deichsel.angle = value;
	self.updateAttacherJoint = true;
end;
